/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authentication.keystore;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.archiva.redback.authentication.AbstractAuthenticator;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authentication.Authenticator;
import org.apache.archiva.redback.authentication.TokenBasedAuthenticationDataSource;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.keys.KeyManagerException;
import org.apache.archiva.redback.keys.KeyNotFoundException;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authenticator#keystore")
public class KeyStoreAuthenticator
extends AbstractAuthenticator
implements Authenticator {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource(name="keyManager#cached")
    private KeyManager keystore;
    @Resource(name="userManager#default")
    private UserManager userManager;

    @PostConstruct
    private void init() {
        this.valid = true;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public AuthenticationResult authenticate(AuthenticationDataSource source) throws AccountLockedException, AuthenticationException, MustChangePasswordException {
        TokenBasedAuthenticationDataSource dataSource = (TokenBasedAuthenticationDataSource)source;
        String key = dataSource.getToken();
        try {
            AuthenticationKey authKey = this.keystore.findKey(key);
            if (authKey != null) {
                User user = this.userManager.findUser(dataSource.getUsername());
                if (user.isLocked()) {
                    throw new AccountLockedException("Account " + source.getUsername() + " is locked.", user);
                }
                if (user.isPasswordChangeRequired() && source.isEnforcePasswordChange()) {
                    throw new MustChangePasswordException("Password expired.", user);
                }
                return new AuthenticationResult(true, dataSource.getUsername(), null);
            }
            return new AuthenticationResult(false, dataSource.getUsername(), (Exception)new AuthenticationException("unable to find key"));
        }
        catch (KeyNotFoundException ne) {
            return new AuthenticationResult(false, null, (Exception)((Object)ne));
        }
        catch (KeyManagerException ke) {
            throw new AuthenticationException("underlaying keymanager issue", (Throwable)ke);
        }
        catch (UserNotFoundException e) {
            this.log.warn("Login for user {} failed. user not found.", (Object)source.getUsername());
            return new AuthenticationResult(false, null, (Exception)((Object)e));
        }
        catch (UserManagerException e) {
            this.log.warn("Login fail for user {} failed. message: {}", (Object)source.getUsername(), (Object)e.getMessage());
            return new AuthenticationResult(false, null, (Exception)((Object)e));
        }
    }

    public boolean supportsDataSource(AuthenticationDataSource source) {
        return source instanceof TokenBasedAuthenticationDataSource;
    }
}

