/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.startup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.common.ArchivaException;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.apache.archiva.security.common.ArchivaRoleConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class SecuritySynchronization
implements RegistryListener {
    private Logger log = LoggerFactory.getLogger(SecuritySynchronization.class);
    @Inject
    private RoleManager roleManager;
    @Inject
    @Named(value="rbacManager#cached")
    private RBACManager rbacManager;
    private Map<String, EnvironmentCheck> checkers;
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initialize() {
        this.checkers = this.getBeansOfType(EnvironmentCheck.class);
    }

    protected <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        Map springBeans = this.applicationContext.getBeansOfType(clazz);
        HashMap beans = new HashMap(springBeans.size());
        for (Map.Entry entry : springBeans.entrySet()) {
            String key = StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"#");
            beans.put(key, entry.getValue());
        }
        return beans;
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isManagedRepositories((String)propertyName) && propertyName.endsWith(".id") && propertyValue != null) {
            this.syncRepoConfiguration((String)propertyValue);
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void synchConfiguration(List<ManagedRepositoryConfiguration> repos) {
        for (ManagedRepositoryConfiguration repoConfig : repos) {
            this.syncRepoConfiguration(repoConfig.getId());
        }
    }

    private void syncRepoConfiguration(String id) {
        try {
            if (!this.roleManager.templatedRoleExists("archiva-repository-observer", id)) {
                this.roleManager.createTemplatedRole("archiva-repository-observer", id);
            } else {
                this.roleManager.verifyTemplatedRole("archiva-repository-observer", id);
            }
            if (!this.roleManager.templatedRoleExists("archiva-repository-manager", id)) {
                this.roleManager.createTemplatedRole("archiva-repository-manager", id);
            } else {
                this.roleManager.verifyTemplatedRole("archiva-repository-manager", id);
            }
        }
        catch (RoleManagerException e) {
            this.log.error("Unable to create roles for configured repositories: " + e.getMessage(), (Throwable)e);
        }
    }

    public void startup() throws ArchivaException {
        this.executeEnvironmentChecks();
        this.synchConfiguration(this.archivaConfiguration.getConfiguration().getManagedRepositories());
        this.archivaConfiguration.addChangeListener((RegistryListener)this);
        if (this.archivaConfiguration.isDefaulted()) {
            this.assignRepositoryObserverToGuestUser(this.archivaConfiguration.getConfiguration().getManagedRepositories());
        }
    }

    private void executeEnvironmentChecks() throws ArchivaException {
        if (this.checkers == null || CollectionUtils.isEmpty(this.checkers.values())) {
            throw new ArchivaException("Unable to initialize the Redback Security Environment, no Environment Check components found.");
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.reset();
        stopWatch.start();
        ArrayList<String> violations = new ArrayList<String>();
        for (Map.Entry<String, EnvironmentCheck> entry : this.checkers.entrySet()) {
            EnvironmentCheck check = entry.getValue();
            ArrayList v = new ArrayList();
            check.validateEnvironment(v);
            this.log.info("Environment Check: {} -> {} violation(s)", (Object)entry.getKey(), (Object)v.size());
            for (String s : v) {
                violations.add("[" + entry.getKey() + "] " + s);
            }
        }
        if (CollectionUtils.isNotEmpty(violations)) {
            StringBuilder msg = new StringBuilder();
            msg.append("EnvironmentCheck Failure.\n");
            msg.append("======================================================================\n");
            msg.append(" ENVIRONMENT FAILURE !! \n");
            msg.append("\n");
            for (String violation : violations) {
                msg.append(violation).append("\n");
            }
            msg.append("\n");
            msg.append("======================================================================");
            this.log.error(msg.toString());
            throw new ArchivaException("Unable to initialize Redback Security Environment, [" + violations.size() + "] violation(s) encountered, See log for details.");
        }
        stopWatch.stop();
        this.log.info("time to execute all EnvironmentCheck: {} ms", (Object)stopWatch.getTime());
    }

    private void assignRepositoryObserverToGuestUser(List<ManagedRepositoryConfiguration> repos) {
        for (ManagedRepositoryConfiguration repoConfig : repos) {
            String repoId = repoConfig.getId();
            String principal = "guest";
            try {
                UserAssignment ua = this.rbacManager.userAssignmentExists(principal) ? this.rbacManager.getUserAssignment(principal) : this.rbacManager.createUserAssignment(principal);
                ua.addRoleName(ArchivaRoleConstants.toRepositoryObserverRoleName((String)repoId));
                this.rbacManager.saveUserAssignment(ua);
            }
            catch (RbacManagerException e) {
                this.log.warn("Unable to add role [{}] to {} user.", new Object[]{ArchivaRoleConstants.toRepositoryObserverRoleName((String)repoId), principal, e});
            }
        }
    }
}

