/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.startup;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class Banner {
    private static final String eol = System.getProperty("line.separator");

    public static String encode(String raw) {
        raw = raw.replace("\r\n", "\n").replace("\r", "\n");
        StringBuilder encoded = new StringBuilder();
        int rawlen = raw.length();
        for (int i = 0; i < rawlen; ++i) {
            char c = raw.charAt(i);
            if (c == '\\') {
                encoded.append("$.");
                continue;
            }
            if (c == '$') {
                encoded.append("$$");
                continue;
            }
            if (c == '\n') {
                encoded.append("$n");
                continue;
            }
            if (Character.isDigit(c)) {
                encoded.append(c);
                continue;
            }
            if (Character.isLetter(c)) {
                encoded.append(Banner.rot13(c));
                continue;
            }
            if (i < raw.length() - 1) {
                boolean done = false;
                int count = 0;
                for (int n = i; !done && n < rawlen; ++n) {
                    char nc = raw.charAt(n);
                    if (nc != c) {
                        done = true;
                        continue;
                    }
                    ++count;
                }
                if (count < 3) {
                    encoded.append(c);
                    continue;
                }
                encoded.append("$").append(String.valueOf(count)).append(c);
                i += count - 1;
                continue;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public static String decode(String encoded) {
        StringBuilder decoded = new StringBuilder();
        int enlen = encoded.length();
        for (int i = 0; i < enlen; ++i) {
            char c = encoded.charAt(i);
            if (c == '$') {
                char nc = encoded.charAt(i + 1);
                if (nc == '$') {
                    decoded.append('$');
                    ++i;
                    continue;
                }
                if (nc == '.') {
                    decoded.append('\\');
                    ++i;
                    continue;
                }
                if (nc == 'n') {
                    decoded.append(eol);
                    ++i;
                    continue;
                }
                if (!Character.isDigit(nc)) continue;
                int count = 0;
                int nn = i + 1;
                while (Character.isDigit(nc)) {
                    count *= 10;
                    count += nc - 48;
                    nc = encoded.charAt(++nn);
                }
                for (int d = 0; d < count; ++d) {
                    decoded.append(nc);
                }
                i = nn;
                continue;
            }
            if (Character.isLetter(c)) {
                decoded.append(Banner.rot13(c));
                continue;
            }
            decoded.append(c);
        }
        return decoded.toString();
    }

    private static char rot13(char c) {
        if (c >= 'a' && c <= 'z') {
            char dc = c = (char)(c + 13);
            if (dc > 'z') {
                dc = (char)(dc - 26);
            }
            return dc;
        }
        if (c >= 'A' && c <= 'Z') {
            char dc = c = (char)(c + 13);
            if (dc > 'Z') {
                dc = (char)(dc - 26);
            }
            return dc;
        }
        return c;
    }

    public static String injectVersion(String text, String version) {
        Pattern pat = Pattern.compile("#{2,}");
        Matcher mat = pat.matcher(text);
        StringBuilder ret = new StringBuilder();
        int off = 0;
        while (mat.find(off)) {
            ret.append(text.substring(off, mat.start()));
            String repl = mat.group();
            ret.append(StringUtils.center((String)version, (int)repl.length()));
            off = mat.end();
        }
        ret.append(text.substring(off));
        return ret.toString();
    }

    public static String getBanner(String version) {
        String encodedBanner = "$26 $34_$n$15 /$._$7 /$34 $.$n$14 /`/@),$4 |  Ba orunys bs nyy bs gur nycnpnf   |$n$14 |  (~'  __| gbvyvat njnl ba gur Ncnpur Nepuvin |$n$6 _,--.$3_/  |$4 $.$5  cebwrpg grnz, V jbhyq yvxr gb$3 |$n$4 ,' ,$5 ($3 |$5 $.$5     jrypbzr lbh gb Nepuvin$6 |$n$4 |  ($6 $.  /$6 |  $32#  |$n$5 $.  )$._/  ,_/$7 |$36 |$n$5 / /$3 ( |/$9 |     uggc://nepuvin.ncnpur.bet/     |$n$4 ( |$4 ( |$10 |     hfref@nepuvin.ncnpur.bet$7 |$n$5 $.|$5 $.|$11 $.$34_/$n$n";
        return Banner.injectVersion(Banner.decode(encodedBanner), version);
    }

    public static void display(String version) {
        String banner = Banner.getBanner(version);
        LoggerFactory.getLogger(Banner.class).info("{} {}{}", new Object[]{StringUtils.repeat((String)"_", (int)25), eol, banner});
    }
}

