/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.startup;

import java.lang.reflect.Field;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.archiva.common.ArchivaException;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.redback.components.scheduler.DefaultScheduler;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.execution.ThreadedTaskQueueExecutor;
import org.apache.archiva.scheduler.repository.DefaultRepositoryArchivaTaskScheduler;
import org.apache.archiva.web.startup.Banner;
import org.apache.archiva.web.startup.SecuritySynchronization;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.quartz.SchedulerException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ArchivaStartup
implements ServletContextListener {
    private ThreadedTaskQueueExecutor tqeDbScanning;
    private ThreadedTaskQueueExecutor tqeRepoScanning;
    private ThreadedTaskQueueExecutor tqeIndexing;
    private DefaultRepositoryArchivaTaskScheduler repositoryTaskScheduler;
    private PlexusSisuBridge plexusSisuBridge;
    private NexusIndexer nexusIndexer;

    public void contextInitialized(ServletContextEvent contextEvent) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)contextEvent.getServletContext());
        SecuritySynchronization securitySync = (SecuritySynchronization)wac.getBean(SecuritySynchronization.class);
        this.repositoryTaskScheduler = (DefaultRepositoryArchivaTaskScheduler)wac.getBean("archivaTaskScheduler#repository", DefaultRepositoryArchivaTaskScheduler.class);
        Properties archivaRuntimeProperties = (Properties)wac.getBean("archivaRuntimeProperties", Properties.class);
        this.tqeRepoScanning = (ThreadedTaskQueueExecutor)wac.getBean("taskQueueExecutor#repository-scanning", ThreadedTaskQueueExecutor.class);
        this.tqeIndexing = (ThreadedTaskQueueExecutor)wac.getBean("taskQueueExecutor#indexing", ThreadedTaskQueueExecutor.class);
        this.plexusSisuBridge = (PlexusSisuBridge)wac.getBean(PlexusSisuBridge.class);
        try {
            this.nexusIndexer = (NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class);
        }
        catch (PlexusSisuBridgeException e) {
            throw new RuntimeException("Unable to get NexusIndexer: " + e.getMessage(), e);
        }
        try {
            securitySync.startup();
            this.repositoryTaskScheduler.startup();
            Banner.display((String)archivaRuntimeProperties.get("archiva.version"));
        }
        catch (ArchivaException e) {
            throw new RuntimeException("Unable to properly startup archiva: " + e.getMessage(), e);
        }
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)contextEvent.getServletContext());
        ServletContext servletContext = contextEvent.getServletContext();
        if (applicationContext != null) {
            this.stopTaskQueueExecutor(this.tqeDbScanning, servletContext);
            this.stopTaskQueueExecutor(this.tqeRepoScanning, servletContext);
            this.stopTaskQueueExecutor(this.tqeIndexing, servletContext);
            if (this.repositoryTaskScheduler != null) {
                try {
                    this.repositoryTaskScheduler.stop();
                }
                catch (SchedulerException e) {
                    servletContext.log(e.getMessage(), (Throwable)e);
                }
                try {
                    Field schedulerField = this.repositoryTaskScheduler.getClass().getDeclaredField("scheduler");
                    schedulerField.setAccessible(true);
                    DefaultScheduler scheduler = (DefaultScheduler)schedulerField.get(this.repositoryTaskScheduler);
                    scheduler.stop();
                }
                catch (Exception e) {
                    servletContext.log(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (IndexingContext indexingContext : this.nexusIndexer.getIndexingContexts().values()) {
            try {
                indexingContext.close(false);
            }
            catch (Exception e) {
                servletContext.log("skip error closing indexingContext " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void stopTaskQueueExecutor(ThreadedTaskQueueExecutor taskQueueExecutor, ServletContext servletContext) {
        if (taskQueueExecutor != null) {
            Task currentTask = taskQueueExecutor.getCurrentTask();
            if (currentTask != null) {
                taskQueueExecutor.cancelTask(currentTask);
            }
            try {
                taskQueueExecutor.stop();
                ExecutorService service = this.getExecutorServiceForTTQE(taskQueueExecutor, servletContext);
                if (service != null) {
                    service.shutdown();
                }
            }
            catch (Exception e) {
                servletContext.log(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ExecutorService getExecutorServiceForTTQE(ThreadedTaskQueueExecutor ttqe, ServletContext servletContext) {
        ExecutorService service = null;
        try {
            Field executorServiceField = ttqe.getClass().getDeclaredField("executorService");
            executorServiceField.setAccessible(true);
            service = (ExecutorService)executorServiceField.get(ttqe);
        }
        catch (Exception e) {
            servletContext.log(e.getMessage(), (Throwable)e);
        }
        return service;
    }
}

