/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.runtime.ldap;

import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.naming.InvalidNameException;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.LdapConfiguration;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.redback.common.ldap.connection.ConfigurableLdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ldapConnectionFactory#archiva")
public class ArchivaLdapConnectionFactory
extends ConfigurableLdapConnectionFactory {
    private final Logger log = LoggerFactory.getLogger(ArchivaLdapConnectionFactory.class);
    private boolean valid = false;
    @Inject
    private RedbackRuntimeConfigurationAdmin redbackRuntimeConfigurationAdmin;
    private LdapConnectionConfiguration ldapConnectionConfiguration;

    @PostConstruct
    public void initialize() {
        try {
            LdapConfiguration ldapConfiguration = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getLdapConfiguration();
            this.ldapConnectionConfiguration = new LdapConnectionConfiguration();
            this.ldapConnectionConfiguration.setHostname(ldapConfiguration.getHostName());
            this.ldapConnectionConfiguration.setPort(ldapConfiguration.getPort());
            this.ldapConnectionConfiguration.setSsl(ldapConfiguration.isSsl());
            this.ldapConnectionConfiguration.setBaseDn(ldapConfiguration.getBaseDn());
            this.ldapConnectionConfiguration.setContextFactory(ldapConfiguration.getContextFactory());
            this.ldapConnectionConfiguration.setBindDn(ldapConfiguration.getBindDn());
            this.ldapConnectionConfiguration.setPassword(ldapConfiguration.getPassword());
            this.ldapConnectionConfiguration.setAuthenticationMethod(ldapConfiguration.getAuthenticationMethod());
            this.ldapConnectionConfiguration.setExtraProperties(this.toProperties(ldapConfiguration.getExtraProperties()));
            this.valid = true;
        }
        catch (InvalidNameException e) {
            this.log.error("Error during initialization of LdapConnectionFactory " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryAdminException e) {
            throw new RuntimeException("Error while initializing ldapConnectionConfiguration: " + e.getMessage(), e);
        }
    }

    private Properties toProperties(Map<String, String> map) {
        Properties properties = new Properties();
        if (map == null) {
            return properties;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public LdapConnectionConfiguration getLdapConnectionConfiguration() {
        return this.ldapConnectionConfiguration;
    }

    public void setLdapConnectionConfiguration(LdapConnectionConfiguration ldapConnectionConfiguration) {
        this.ldapConnectionConfiguration = ldapConnectionConfiguration;
    }

    public boolean isValid() {
        return this.valid;
    }
}

