/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.runtime;

import java.util.Date;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.stereotype.Service;

@Service(value="archivaRuntimeInfo")
public class ArchivaRuntimeInfo {
    private String version;
    private String buildNumber;
    private long timestamp;
    private boolean devMode;

    @Inject
    public ArchivaRuntimeInfo(@Named(value="archivaRuntimeProperties") Properties archivaRuntimeProperties) {
        this.version = (String)archivaRuntimeProperties.get("archiva.version");
        this.buildNumber = (String)archivaRuntimeProperties.get("archiva.buildNumber");
        String archivaTimeStamp = (String)archivaRuntimeProperties.get("archiva.timestamp");
        this.timestamp = NumberUtils.isNumber((String)archivaTimeStamp) ? NumberUtils.createLong((String)archivaTimeStamp).longValue() : new Date().getTime();
        this.devMode = Boolean.getBoolean("archiva.devMode");
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArchivaRuntimeInfo");
        sb.append("{version='").append(this.version).append('\'');
        sb.append(", buildNumber='").append(this.buildNumber).append('\'');
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", devMode=").append(this.devMode);
        sb.append('}');
        return sb.toString();
    }
}

