/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.authorization.UnauthorizedException;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.rss.processor.RssFeedProcessor;
import org.apache.archiva.security.AccessDeniedException;
import org.apache.archiva.security.ArchivaSecurityException;
import org.apache.archiva.security.PrincipalNotFoundException;
import org.apache.archiva.security.ServletAuthenticator;
import org.apache.archiva.security.UserRepositories;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RssFeedServlet
extends HttpServlet {
    public static final String MIME_TYPE = "application/rss+xml; charset=UTF-8";
    private static final String COULD_NOT_GENERATE_FEED_ERROR = "Could not generate feed";
    private static final String COULD_NOT_AUTHENTICATE_USER = "Could not authenticate user";
    private static final String USER_NOT_AUTHORIZED = "User not authorized to access feed.";
    private Logger log = LoggerFactory.getLogger(RssFeedServlet.class);
    private WebApplicationContext wac;
    private UserRepositories userRepositories;
    private ServletAuthenticator servletAuth;
    private HttpAuthenticator httpAuth;
    private RssFeedProcessor newArtifactsprocessor;
    private RssFeedProcessor newVersionsprocessor;
    private RepositorySessionFactory repositorySessionFactory;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletConfig.getServletContext());
        this.userRepositories = (UserRepositories)this.wac.getBean(UserRepositories.class);
        this.servletAuth = (ServletAuthenticator)this.wac.getBean(ServletAuthenticator.class);
        this.httpAuth = (HttpAuthenticator)this.wac.getBean("httpAuthenticator#basic", HttpAuthenticator.class);
        this.repositorySessionFactory = (RepositorySessionFactory)this.wac.getBean("repositorySessionFactory", RepositorySessionFactory.class);
        this.newArtifactsprocessor = (RssFeedProcessor)this.wac.getBean("rssFeedProcessor#new-artifacts", RssFeedProcessor.class);
        this.newVersionsprocessor = (RssFeedProcessor)this.wac.getBean("rssFeedProcessor#new-versions", RssFeedProcessor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String repoId = null;
        String groupId = null;
        String artifactId = null;
        String url = StringUtils.removeEnd((String)req.getRequestURL().toString(), (String)"/");
        if (StringUtils.countMatches((String)StringUtils.substringAfter((String)url, (String)"feeds/"), (String)"/") > 0) {
            artifactId = StringUtils.substringAfterLast((String)url, (String)"/");
            groupId = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)url, (String)"feeds/"), (String)"/");
            groupId = StringUtils.replaceChars((String)groupId, (char)'/', (char)'.');
        } else if (StringUtils.countMatches((String)StringUtils.substringAfter((String)url, (String)"feeds/"), (String)"/") == 0) {
            if (StringUtils.countMatches((String)url, (String)"feeds?") > 0) {
                res.sendError(400, "Invalid request url.");
                return;
            }
            repoId = StringUtils.substringAfterLast((String)url, (String)"/");
        } else {
            res.sendError(400, "Invalid request url.");
            return;
        }
        RssFeedProcessor processor = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            SyndFeed feed = null;
            if (this.isAllowed(req, repoId, groupId, artifactId)) {
                if (repoId != null) {
                    processor = this.newArtifactsprocessor;
                    map.put("repoId", repoId);
                } else if (groupId != null && artifactId != null) {
                    processor = this.newVersionsprocessor;
                    map.put("groupId", groupId);
                    map.put("artifactId", artifactId);
                }
            } else {
                res.sendError(401, USER_NOT_AUTHORIZED);
                return;
            }
            try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
                feed = processor.process(map, repositorySession.getRepository());
            }
            if (feed == null) {
                res.sendError(204, "No information available.");
                return;
            }
            res.setContentType(MIME_TYPE);
            if (repoId != null) {
                feed.setLink(req.getRequestURL().toString());
            } else if (groupId != null && artifactId != null) {
                feed.setLink(req.getRequestURL().toString());
            }
            SyndFeedOutput output = new SyndFeedOutput();
            output.output(feed, (Writer)res.getWriter());
        }
        catch (UserNotFoundException unfe) {
            this.log.debug(COULD_NOT_AUTHENTICATE_USER, (Throwable)unfe);
            res.sendError(401, COULD_NOT_AUTHENTICATE_USER);
        }
        catch (AccountLockedException acce) {
            res.sendError(401, COULD_NOT_AUTHENTICATE_USER);
        }
        catch (AuthenticationException authe) {
            this.log.debug(COULD_NOT_AUTHENTICATE_USER, (Throwable)authe);
            res.sendError(401, COULD_NOT_AUTHENTICATE_USER);
        }
        catch (FeedException ex) {
            this.log.debug(COULD_NOT_GENERATE_FEED_ERROR, (Throwable)ex);
            res.sendError(500, COULD_NOT_GENERATE_FEED_ERROR);
        }
        catch (MustChangePasswordException e) {
            res.sendError(401, COULD_NOT_AUTHENTICATE_USER);
        }
        catch (UnauthorizedException e) {
            this.log.debug(e.getMessage());
            if (repoId != null) {
                res.setHeader("WWW-Authenticate", "Basic realm=\"Repository Archiva Managed " + repoId + " Repository");
            } else {
                res.setHeader("WWW-Authenticate", "Basic realm=\"Artifact " + groupId + ":" + artifactId);
            }
            res.sendError(401, USER_NOT_AUTHORIZED);
        }
    }

    private boolean isAllowed(HttpServletRequest req, String repositoryId, String groupId, String artifactId) throws UserNotFoundException, AccountLockedException, AuthenticationException, MustChangePasswordException, UnauthorizedException {
        String auth = req.getHeader("Authorization");
        List<String> repoIds = new ArrayList<String>();
        if (repositoryId != null) {
            repoIds.add(repositoryId);
        } else if (artifactId != null && groupId != null) {
            if (auth != null) {
                if (!auth.toUpperCase().startsWith("BASIC ")) {
                    return false;
                }
                Base64 dec = new Base64();
                String usernamePassword = "";
                try {
                    usernamePassword = new String((byte[])dec.decode((Object)auth.substring(6).getBytes()));
                }
                catch (DecoderException ie) {
                    this.log.warn("Error decoding username and password: {}", (Object)ie.getMessage());
                }
                if (usernamePassword == null || usernamePassword.trim().equals("")) {
                    repoIds = this.getObservableRepos("guest");
                } else {
                    String[] userCredentials = usernamePassword.split(":");
                    repoIds = this.getObservableRepos(userCredentials[0]);
                }
            } else {
                repoIds = this.getObservableRepos("guest");
            }
        } else {
            return false;
        }
        for (String repoId : repoIds) {
            try {
                AuthenticationResult result = this.httpAuth.getAuthenticationResult(req, null);
                SecuritySession securitySession = this.httpAuth.getSecuritySession(req.getSession(true));
                if (!this.servletAuth.isAuthenticated(req, result) || !this.servletAuth.isAuthorized(req, securitySession, repoId, "archiva-read-repository")) continue;
                return true;
            }
            catch (AuthorizationException e) {
                this.log.debug("AuthorizationException for repoId: {}", (Object)repoId);
            }
            catch (UnauthorizedException e) {
                this.log.debug("UnauthorizedException for repoId: {}", (Object)repoId);
            }
        }
        throw new UnauthorizedException("Access denied.");
    }

    private List<String> getObservableRepos(String principal) {
        try {
            return this.userRepositories.getObservableRepositoryIds(principal);
        }
        catch (PrincipalNotFoundException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (AccessDeniedException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ArchivaSecurityException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }
}

