/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.api;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.web.model.FileMetadata;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;

@Path(value="/fileUploadService/")
public interface FileUploadService {
    public static final String FILES_SESSION_KEY = FileUploadService.class.getName() + "files_session_key";

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-upload-repository"})
    public FileMetadata post(MultipartBody var1) throws ArchivaRestServiceException;

    @Path(value="{fileName}")
    @DELETE
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-upload-repository"})
    public Boolean deleteFile(@PathParam(value="fileName") String var1) throws ArchivaRestServiceException;

    @Path(value="sessionFileMetadatas")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-upload-repository"})
    public List<FileMetadata> getSessionFileMetadatas() throws ArchivaRestServiceException;

    @Path(value="save/{repositoryId}/{groupId}/{artifactId}/{version}/{packaging}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(resource="{repositoryId}", permissions={"archiva-upload-repository"})
    public Boolean save(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3, @PathParam(value="version") String var4, @PathParam(value="packaging") String var5, @QueryParam(value="generatePom") boolean var6) throws ArchivaRestServiceException;

    @Path(value="clearUploadedFiles")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-upload-repository"})
    public Boolean clearUploadedFiles() throws ArchivaRestServiceException;
}

