/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.apache.archiva.admin.model.beans.RedbackRuntimeConfiguration;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.RedbackRuntimeConfigurationService;
import org.apache.archiva.web.api.RuntimeInfoService;
import org.apache.archiva.web.model.ApplicationRuntimeInfo;
import org.apache.archiva.web.model.CookieInformation;
import org.apache.archiva.web.runtime.ArchivaRuntimeInfo;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="runtimeInfoService#rest")
public class DefaultRuntimeInfoService
implements RuntimeInfoService {
    private Logger i18nLogger = LoggerFactory.getLogger((String)"archivaMissingi18n.logger");
    private ArchivaRuntimeInfo archivaRuntimeInfo;
    @Inject
    private RedbackRuntimeConfigurationService redbackRuntimeConfigurationService;
    @Context
    protected HttpServletRequest httpServletRequest;

    @Inject
    public DefaultRuntimeInfoService(ArchivaRuntimeInfo archivaRuntimeInfo) {
        this.archivaRuntimeInfo = archivaRuntimeInfo;
    }

    @Override
    public ApplicationRuntimeInfo getApplicationRuntimeInfo(String locale) throws ArchivaRestServiceException {
        ApplicationRuntimeInfo applicationRuntimeInfo = new ApplicationRuntimeInfo();
        applicationRuntimeInfo.setBuildNumber(this.archivaRuntimeInfo.getBuildNumber());
        applicationRuntimeInfo.setTimestamp(this.archivaRuntimeInfo.getTimestamp());
        applicationRuntimeInfo.setVersion(this.archivaRuntimeInfo.getVersion());
        applicationRuntimeInfo.setBaseUrl(this.getBaseUrl(this.httpServletRequest));
        SimpleDateFormat sfd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz", new Locale(StringUtils.isEmpty((String)locale) ? "en" : locale));
        applicationRuntimeInfo.setTimestampStr(sfd.format(new Date(this.archivaRuntimeInfo.getTimestamp())));
        CookieInformation cookieInformation = new CookieInformation();
        RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.redbackRuntimeConfigurationService.getRedbackRuntimeConfiguration();
        cookieInformation.setDomain((String)redbackRuntimeConfiguration.getConfigurationProperties().get("security.rememberme.domain"));
        cookieInformation.setPath((String)redbackRuntimeConfiguration.getConfigurationProperties().get("security.rememberme.path"));
        cookieInformation.setSecure((String)redbackRuntimeConfiguration.getConfigurationProperties().get("security.rememberme.secure"));
        cookieInformation.setTimeout((String)redbackRuntimeConfiguration.getConfigurationProperties().get("security.rememberme.timeout"));
        cookieInformation.setRememberMeEnabled(BooleanUtils.toBoolean((String)((String)redbackRuntimeConfiguration.getConfigurationProperties().get("security.rememberme.enabled"))));
        applicationRuntimeInfo.setCookieInformation(cookieInformation);
        return applicationRuntimeInfo;
    }

    protected String getBaseUrl(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + (req.getServerPort() == 80 ? "" : ":" + req.getServerPort()) + req.getContextPath();
    }

    @Override
    public Boolean logMissingI18n(String key) {
        this.i18nLogger.info("missing i18n key : '{}'", (Object)key);
        return Boolean.TRUE;
    }
}

