/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.api;

import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.group.RepositoryGroupAdmin;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.web.api.DataValidatorService;
import org.springframework.stereotype.Service;

@Service(value="dataValidatorService#rest")
public class DefaultDataValidatorService
implements DataValidatorService {
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    @Inject
    private NetworkProxyAdmin networkProxyAdmin;
    @Inject
    private RepositoryGroupAdmin repositoryGroupAdmin;

    @Override
    public Boolean managedRepositoryIdNotExists(String id) throws ArchivaRestServiceException {
        try {
            return this.idExist(id) == false;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Boolean remoteRepositoryIdNotExists(String id) throws ArchivaRestServiceException {
        try {
            return this.idExist(id) == false;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Boolean networkProxyIdNotExists(String id) throws ArchivaRestServiceException {
        try {
            return this.networkProxyAdmin.getNetworkProxy(id) == null;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    private Boolean idExist(String id) throws RepositoryAdminException {
        return this.managedRepositoryAdmin.getManagedRepository(id) != null || this.remoteRepositoryAdmin.getRemoteRepository(id) != null || this.repositoryGroupAdmin.getRepositoryGroup(id) != null;
    }
}

