/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.audit;

import javax.inject.Inject;
import org.apache.archiva.audit.AuditManager;
import org.apache.archiva.metadata.model.facets.AuditEvent;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.repository.events.AuditListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="auditListener#metadata")
public class MetadataAuditListener
implements AuditListener {
    private static final Logger log = LoggerFactory.getLogger(MetadataAuditListener.class);
    @Inject
    private AuditManager auditManager;
    @Inject
    private RepositorySessionFactory repositorySessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditEvent(AuditEvent event) {
        if (event.getAction().equals("Created File") || event.getAction().equals("Uploaded File") || event.getAction().equals("Merged Artifact")) {
            try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
                this.auditManager.addAuditEvent(repositorySession.getRepository(), event);
                repositorySession.save();
            }
        }
    }
}

