/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.audit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.archiva.audit.AuditManager;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.facets.AuditEvent;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="auditManager#default")
public class DefaultAuditManager
implements AuditManager {
    private static final int NUM_RECENT_EVENTS = 10;
    private static final Logger log = LoggerFactory.getLogger(DefaultAuditManager.class);
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");

    @Override
    public List<AuditEvent> getMostRecentAuditEvents(MetadataRepository metadataRepository, List<String> repositoryIds) throws MetadataRepositoryException {
        List<AuditRecord> records = new ArrayList();
        for (String repositoryId : repositoryIds) {
            List names = metadataRepository.getMetadataFacets(repositoryId, "org.apache.archiva.audit");
            for (String name : names) {
                records.add(new AuditRecord(repositoryId, name));
            }
        }
        Collections.sort(records);
        records = records.subList(0, records.size() < 10 ? records.size() : 10);
        ArrayList<AuditEvent> events = new ArrayList<AuditEvent>(records.size());
        for (AuditRecord record : records) {
            AuditEvent auditEvent = (AuditEvent)metadataRepository.getMetadataFacet(record.repositoryId, "org.apache.archiva.audit", record.name);
            events.add(auditEvent);
        }
        return events;
    }

    @Override
    public void addAuditEvent(MetadataRepository repository, AuditEvent event) throws MetadataRepositoryException {
        if (event.getRepositoryId() != null) {
            repository.addMetadataFacet(event.getRepositoryId(), (MetadataFacet)event);
        }
    }

    @Override
    public void deleteAuditEvents(MetadataRepository metadataRepository, String repositoryId) throws MetadataRepositoryException {
        metadataRepository.removeMetadataFacets(repositoryId, "org.apache.archiva.audit");
    }

    @Override
    public List<AuditEvent> getAuditEventsInRange(MetadataRepository metadataRepository, Collection<String> repositoryIds, Date startTime, Date endTime) throws MetadataRepositoryException {
        return this.getAuditEventsInRange(metadataRepository, repositoryIds, null, startTime, endTime);
    }

    @Override
    public List<AuditEvent> getAuditEventsInRange(MetadataRepository metadataRepository, Collection<String> repositoryIds, String resource, Date startTime, Date endTime) throws MetadataRepositoryException {
        ArrayList<AuditEvent> results = new ArrayList<AuditEvent>();
        for (String repositoryId : repositoryIds) {
            List list = metadataRepository.getMetadataFacets(repositoryId, "org.apache.archiva.audit");
            for (String name : list) {
                try {
                    Date date = DefaultAuditManager.createNameFormat().parse(name);
                    if (startTime != null && date.before(startTime) || endTime != null && date.after(endTime)) continue;
                    AuditEvent event = (AuditEvent)metadataRepository.getMetadataFacet(repositoryId, "org.apache.archiva.audit", name);
                    if (resource != null && !event.getResource().startsWith(resource)) continue;
                    results.add(event);
                }
                catch (ParseException e) {
                    log.error("Invalid audit event found in the metadata repository: " + e.getMessage());
                }
            }
        }
        Collections.sort(results, new Comparator<AuditEvent>(){

            @Override
            public int compare(AuditEvent o1, AuditEvent o2) {
                return o2.getTimestamp().compareTo(o1.getTimestamp());
            }
        });
        return results;
    }

    private static SimpleDateFormat createNameFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd/HHmmss.SSS");
        fmt.setTimeZone(UTC_TIME_ZONE);
        return fmt;
    }

    private static final class AuditRecord
    implements Comparable<AuditRecord> {
        private String repositoryId;
        private String name;

        public AuditRecord(String repositoryId, String name) {
            this.repositoryId = repositoryId;
            this.name = name;
        }

        @Override
        public int compareTo(AuditRecord other) {
            return other.name.compareTo(this.name);
        }
    }
}

