/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.audit;

import org.apache.archiva.metadata.model.facets.AuditEvent;
import org.apache.archiva.repository.events.AuditListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="auditListener#logging")
public class AuditLog
implements AuditListener {
    public static final Logger logger = LoggerFactory.getLogger((String)"org.apache.archiva.AuditLog");
    private static final String NONE = "-";
    private static final char DELIM = ' ';

    public void auditEvent(AuditEvent event) {
        StringBuilder msg = new StringBuilder();
        msg.append(this.checkNull(event.getRepositoryId())).append(' ');
        msg.append(event.getUserId()).append(' ');
        msg.append(this.checkNull(event.getRemoteIP())).append(' ');
        msg.append('\"').append(this.checkNull(event.getResource())).append('\"').append(' ');
        msg.append('\"').append(event.getAction()).append('\"');
        logger.info(msg.toString());
    }

    private String checkNull(String s) {
        return s != null ? s : NONE;
    }
}

