/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.metadata.model.MetadataFacetFactory;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataResolver;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.cassandra.CassandraArchivaManager;
import org.apache.archiva.metadata.repository.cassandra.CassandraMetadataRepository;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="repositorySessionFactory#cassandra")
public class CassandraRepositorySessionFactory
implements RepositorySessionFactory {
    private Map<String, MetadataFacetFactory> metadataFacetFactories;
    @Inject
    @Named(value="archivaConfiguration#default")
    private ArchivaConfiguration configuration;
    @Inject
    private MetadataResolver metadataResolver;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private CassandraArchivaManager cassandraArchivaManager;

    @PostConstruct
    public void initialize() {
        Map tmpMetadataFacetFactories = this.applicationContext.getBeansOfType(MetadataFacetFactory.class);
        this.metadataFacetFactories = new HashMap<String, MetadataFacetFactory>(tmpMetadataFacetFactories.size());
        for (Map.Entry entry : tmpMetadataFacetFactories.entrySet()) {
            this.metadataFacetFactories.put(StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"#"), (MetadataFacetFactory)entry.getValue());
        }
    }

    public RepositorySession createSession() {
        CassandraMetadataRepository metadataRepository = new CassandraMetadataRepository(this.metadataFacetFactories, this.configuration, this.cassandraArchivaManager);
        return new RepositorySession((MetadataRepository)metadataRepository, this.metadataResolver);
    }
}

