/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.common.utils;

import java.io.File;
import java.net.URI;
import org.apache.archiva.common.utils.PathUtil;

public class BaseFile
extends File {
    private File baseDir;

    public BaseFile(File pathFile) {
        this(pathFile.getAbsolutePath());
    }

    public BaseFile(File repoDir, File pathFile) {
        this(repoDir, PathUtil.getRelative(repoDir.getAbsolutePath(), pathFile));
    }

    public BaseFile(File parent, String child) {
        super(parent, child);
        this.baseDir = parent;
    }

    public BaseFile(String pathname) {
        super(pathname);
        File parent = this;
        while (parent.getParentFile() != null) {
            parent = parent.getParentFile();
        }
        this.baseDir = parent;
    }

    public BaseFile(String repoDir, File pathFile) {
        this(new File(repoDir), pathFile);
    }

    public BaseFile(String parent, String child) {
        super(parent, child);
        this.baseDir = new File(parent);
    }

    public BaseFile(URI uri) {
        super(uri);
        throw new IllegalStateException("The " + BaseFile.class.getName() + " object does not support URI construction.");
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String getRelativePath() {
        return PathUtil.getRelative(this.baseDir.getAbsolutePath(), this);
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setBaseDir(String repoDir) {
        this.setBaseDir(new File(repoDir));
    }
}

