/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class WebdavMethodUtil {
    private static final List<String> READ_METHODS = new ArrayList<String>(5);

    public static String getMethodPermission(String method) {
        if (StringUtils.isBlank((String)method)) {
            throw new IllegalArgumentException("WebDAV method is empty");
        }
        if (READ_METHODS.contains(method.toUpperCase(Locale.US))) {
            return "archiva-read-repository";
        }
        if ("DELETE".equals(method.toUpperCase(Locale.US))) {
            return "archiva-delete-artifact";
        }
        return "archiva-upload-repository";
    }

    public static boolean isReadMethod(String method) {
        if (StringUtils.isBlank((String)method)) {
            throw new IllegalArgumentException("WebDAV method is empty");
        }
        return READ_METHODS.contains(method.toUpperCase(Locale.US));
    }

    static {
        READ_METHODS.add("HEAD");
        READ_METHODS.add("GET");
        READ_METHODS.add("PROPFIND");
        READ_METHODS.add("OPTIONS");
        READ_METHODS.add("REPORT");
    }
}

