/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav.util;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.archiva.indexer.merger.IndexMerger;
import org.apache.archiva.indexer.merger.TemporaryGroupIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TemporaryGroupIndexSessionCleaner
implements HttpSessionListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private IndexMerger indexMerger;
    public static final String TEMPORARY_INDEX_SESSION_KEY = TemporaryGroupIndexSessionCleaner.class.getName();

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (httpSessionEvent.getSession().getAttribute(TEMPORARY_INDEX_SESSION_KEY) == null) {
            httpSessionEvent.getSession().setAttribute(TEMPORARY_INDEX_SESSION_KEY, new HashMap());
        }
        if (this.indexMerger == null) {
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)httpSessionEvent.getSession().getServletContext());
            this.indexMerger = (IndexMerger)webApplicationContext.getBean(IndexMerger.class);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        Map tempFilesPerKey = (Map)httpSessionEvent.getSession().getAttribute(TEMPORARY_INDEX_SESSION_KEY);
        for (TemporaryGroupIndex temporaryGroupIndex : tempFilesPerKey.values()) {
            this.log.info("cleanup temporaryGroupIndex {} directory {}", (Object)temporaryGroupIndex.getIndexId(), (Object)temporaryGroupIndex.getDirectory().getAbsolutePath());
            this.getIndexMerger(httpSessionEvent).cleanTemporaryGroupIndex(temporaryGroupIndex);
        }
    }

    private IndexMerger getIndexMerger(HttpSessionEvent httpSessionEvent) {
        if (this.indexMerger == null) {
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)httpSessionEvent.getSession().getServletContext());
            this.indexMerger = (IndexMerger)webApplicationContext.getBean(IndexMerger.class);
        }
        return this.indexMerger;
    }
}

