/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationEvent;
import org.apache.archiva.configuration.ConfigurationListener;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.security.ServletAuthenticator;
import org.apache.archiva.webdav.ArchivaDavLocatorFactory;
import org.apache.archiva.webdav.ArchivaDavSessionProvider;
import org.apache.archiva.webdav.BrowserRedirectException;
import org.apache.archiva.webdav.UnauthorizedDavException;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavRequestImpl;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.WebdavResponseImpl;
import org.apache.jackrabbit.webdav.server.AbstractWebdavServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RepositoryServlet
extends AbstractWebdavServlet
implements ConfigurationListener {
    private Logger log = LoggerFactory.getLogger(RepositoryServlet.class);
    private ArchivaConfiguration configuration;
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    private Map<String, ManagedRepository> repositoryMap;
    private DavLocatorFactory locatorFactory;
    private DavResourceFactory resourceFactory;
    private DavSessionProvider sessionProvider;
    private final Object reloadLock = new Object();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.initServers(servletConfig);
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebdavRequestImpl webdavRequest = new WebdavRequestImpl(request, this.getLocatorFactory());
        int methodCode = DavMethods.getMethodCode((String)request.getMethod());
        boolean noCache = DavMethods.isDeltaVMethod((DavServletRequest)webdavRequest) && 20 != methodCode && 19 != methodCode;
        WebdavResponseImpl webdavResponse = new WebdavResponseImpl(response, noCache);
        DavResource resource = null;
        try {
            if (!this.getDavSessionProvider().attachSession((WebdavRequest)webdavRequest)) {
                return;
            }
            resource = this.getResourceFactory().createResource(webdavRequest.getRequestLocator(), (DavServletRequest)webdavRequest, (DavServletResponse)webdavResponse);
            if (!this.isPreconditionValid((WebdavRequest)webdavRequest, resource)) {
                webdavResponse.sendError(412);
                return;
            }
            if (!this.execute((WebdavRequest)webdavRequest, (WebdavResponse)webdavResponse, methodCode, resource)) {
                super.service(request, response);
            }
        }
        catch (UnauthorizedDavException e) {
            webdavResponse.setHeader("WWW-Authenticate", this.getAuthenticateHeaderValue(e.getRepositoryName()));
            webdavResponse.sendError(e.getErrorCode(), e.getStatusPhrase());
        }
        catch (BrowserRedirectException e) {
            response.sendRedirect(e.getLocation());
        }
        catch (DavException e) {
            if (e.getErrorCode() == 401) {
                String msg = "Should throw " + UnauthorizedDavException.class.getName();
                this.log.error(msg);
                webdavResponse.sendError(e.getErrorCode(), msg);
            } else if (e.getCause() != null) {
                webdavResponse.sendError(e.getErrorCode(), e.getCause().getMessage());
            } else {
                webdavResponse.sendError(e.getErrorCode(), e.getMessage());
            }
        }
        finally {
            this.getDavSessionProvider().releaseSession((WebdavRequest)webdavRequest);
        }
    }

    public synchronized void initServers(ServletConfig servletConfig) throws RepositoryAdminException {
        long start = System.currentTimeMillis();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletConfig.getServletContext());
        this.configuration = (ArchivaConfiguration)wac.getBean("archivaConfiguration#default", ArchivaConfiguration.class);
        this.configuration.addListener((ConfigurationListener)this);
        this.managedRepositoryAdmin = (ManagedRepositoryAdmin)wac.getBean(ManagedRepositoryAdmin.class);
        this.repositoryMap = this.managedRepositoryAdmin.getManagedRepositoriesAsMap();
        for (ManagedRepository repo : this.repositoryMap.values()) {
            File repoDir = new File(repo.getLocation());
            if (repoDir.exists() || repoDir.mkdirs()) continue;
            this.log.info("Unable to create missing directory for {}", (Object)repo.getLocation());
        }
        this.resourceFactory = (DavResourceFactory)wac.getBean("davResourceFactory#archiva", DavResourceFactory.class);
        this.locatorFactory = new ArchivaDavLocatorFactory();
        ServletAuthenticator servletAuth = (ServletAuthenticator)wac.getBean(ServletAuthenticator.class);
        HttpAuthenticator httpAuth = (HttpAuthenticator)wac.getBean("httpAuthenticator#basic", HttpAuthenticator.class);
        this.sessionProvider = new ArchivaDavSessionProvider(servletAuth, httpAuth);
        long end = System.currentTimeMillis();
        this.log.info("initServers done in {}\u00a0ms", (Object)(end - start));
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1) {
            try {
                this.initRepositories();
            }
            catch (RepositoryAdminException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositories() throws RepositoryAdminException {
        Object object = this.repositoryMap;
        synchronized (object) {
            this.repositoryMap.clear();
            this.repositoryMap.putAll(this.managedRepositoryAdmin.getManagedRepositoriesAsMap());
        }
        object = this.reloadLock;
        synchronized (object) {
            this.initServers(this.getServletConfig());
        }
    }

    public synchronized ManagedRepository getRepository(String prefix) throws RepositoryAdminException {
        if (this.repositoryMap.isEmpty()) {
            this.repositoryMap.putAll(this.managedRepositoryAdmin.getManagedRepositoriesAsMap());
        }
        return this.repositoryMap.get(prefix);
    }

    ArchivaConfiguration getConfiguration() {
        return this.configuration;
    }

    protected boolean isPreconditionValid(WebdavRequest request, DavResource davResource) {
        return true;
    }

    public DavSessionProvider getDavSessionProvider() {
        return this.sessionProvider;
    }

    public void setDavSessionProvider(DavSessionProvider davSessionProvider) {
        this.sessionProvider = davSessionProvider;
    }

    public DavLocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    public void setLocatorFactory(DavLocatorFactory davLocatorFactory) {
        this.locatorFactory = davLocatorFactory;
    }

    public DavResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(DavResourceFactory davResourceFactory) {
        this.resourceFactory = davResourceFactory;
    }

    public String getAuthenticateHeaderValue() {
        throw new UnsupportedOperationException();
    }

    public String getAuthenticateHeaderValue(String repository) {
        return "Basic realm=\"Repository Archiva Managed " + repository + " Repository\"";
    }

    public void destroy() {
        this.configuration.removeListener((ConfigurationListener)this);
        this.resourceFactory = null;
        this.configuration = null;
        this.locatorFactory = null;
        this.sessionProvider = null;
        this.repositoryMap.clear();
        this.repositoryMap = null;
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        if (wac instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)wac).close();
        }
        super.destroy();
    }
}

