/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav;

import org.apache.archiva.webdav.ArchivaDavResourceLocator;
import org.apache.archiva.webdav.util.RepositoryPathUtil;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;

public class ArchivaDavLocatorFactory
implements DavLocatorFactory {
    public DavResourceLocator createResourceLocator(String prefix, String href) {
        StringBuilder b = new StringBuilder();
        if (prefix != null && prefix.length() > 0) {
            b.append(prefix);
            if (!prefix.endsWith("/")) {
                b.append('/');
            }
            if (href.startsWith(prefix)) {
                href = href.substring(prefix.length());
            }
        }
        if (href == null || "".equals(href)) {
            href = "/";
        }
        String repository = RepositoryPathUtil.getRepositoryName(href);
        return new ArchivaDavResourceLocator(b.toString(), Text.unescape((String)href), repository, this);
    }

    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String resourcePath) {
        return this.createResourceLocator(prefix, workspacePath, resourcePath, true);
    }

    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String path, boolean isResourcePath) {
        String repository = RepositoryPathUtil.getRepositoryName(path);
        return new ArchivaDavResourceLocator(prefix, path, repository, this);
    }
}

