/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.archiva.model.Plugin;
import org.apache.archiva.model.SnapshotVersion;

public class ArchivaRepositoryMetadata
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private String latestVersion;
    private String releasedVersion;
    private SnapshotVersion snapshotVersion;
    private List<Plugin> plugins;
    private List<String> availableVersions;
    private String lastUpdated;
    private Date fileLastModified;
    private long fileSize = 0L;
    private static final long serialVersionUID = 914715358219606100L;

    public void addAvailableVersion(String string) {
        this.getAvailableVersions().add(string);
    }

    public void addPlugin(Plugin plugin) {
        this.getPlugins().add(plugin);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArchivaRepositoryMetadata)) {
            return false;
        }
        ArchivaRepositoryMetadata that = (ArchivaRepositoryMetadata)other;
        boolean result = true;
        boolean bl = result && (this.getGroupId() == null ? that.getGroupId() == null : this.getGroupId().equals(that.getGroupId())) ? true : (result = false);
        boolean bl2 = result && (this.getArtifactId() == null ? that.getArtifactId() == null : this.getArtifactId().equals(that.getArtifactId())) ? true : (result = false);
        result = result && (this.getVersion() == null ? that.getVersion() == null : this.getVersion().equals(that.getVersion()));
        return result;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public List<String> getAvailableVersions() {
        if (this.availableVersions == null) {
            this.availableVersions = new ArrayList<String>();
        }
        return this.availableVersions;
    }

    public Date getFileLastModified() {
        return this.fileLastModified;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Plugin>();
        }
        return this.plugins;
    }

    public String getReleasedVersion() {
        return this.releasedVersion;
    }

    public SnapshotVersion getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
        result = 37 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 37 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public void removeAvailableVersion(String string) {
        this.getAvailableVersions().remove(string);
    }

    public void removePlugin(Plugin plugin) {
        this.getPlugins().remove(plugin);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setAvailableVersions(List<String> availableVersions) {
        this.availableVersions = availableVersions;
    }

    public void setFileLastModified(Date fileLastModified) {
        this.fileLastModified = fileLastModified;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    public void setReleasedVersion(String releasedVersion) {
        this.releasedVersion = releasedVersion;
    }

    public void setSnapshotVersion(SnapshotVersion snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("groupId = '");
        buf.append(this.getGroupId());
        buf.append("'");
        buf.append("\n");
        buf.append("artifactId = '");
        buf.append(this.getArtifactId());
        buf.append("'");
        buf.append("\n");
        buf.append("version = '");
        buf.append(this.getVersion());
        buf.append("'");
        return buf.toString();
    }

    public void updateTimestamp() {
        this.setLastUpdatedTimestamp(new Date());
    }

    public void setLastUpdatedTimestamp(Date date) {
        TimeZone timezone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
        fmt.setTimeZone(timezone);
        this.setLastUpdated(fmt.format(date));
    }
}

