/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.SnapshotVersion;
import org.apache.archiva.model.VersionedReference;

public class ArchivaModelCloner {
    public static ArtifactReference clone(ArtifactReference artifactReference) {
        if (artifactReference == null) {
            return null;
        }
        ArtifactReference cloned = new ArtifactReference();
        cloned.setGroupId(artifactReference.getGroupId());
        cloned.setArtifactId(artifactReference.getArtifactId());
        cloned.setVersion(artifactReference.getVersion());
        cloned.setClassifier(artifactReference.getClassifier());
        cloned.setType(artifactReference.getType());
        return cloned;
    }

    public static Properties clone(Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties cloned = new Properties();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            cloned.setProperty(key, value);
        }
        return cloned;
    }

    public static SnapshotVersion clone(SnapshotVersion snapshotVersion) {
        if (snapshotVersion == null) {
            return null;
        }
        SnapshotVersion cloned = new SnapshotVersion();
        cloned.setTimestamp(snapshotVersion.getTimestamp());
        cloned.setBuildNumber(snapshotVersion.getBuildNumber());
        return cloned;
    }

    public static VersionedReference clone(VersionedReference versionedReference) {
        if (versionedReference == null) {
            return null;
        }
        VersionedReference cloned = new VersionedReference();
        cloned.setGroupId(versionedReference.getGroupId());
        cloned.setArtifactId(versionedReference.getArtifactId());
        cloned.setVersion(versionedReference.getVersion());
        return cloned;
    }

    public static List<ArtifactReference> cloneArtifactReferences(List<ArtifactReference> artifactReferenceList) {
        if (artifactReferenceList == null) {
            return null;
        }
        ArrayList<ArtifactReference> ret = new ArrayList<ArtifactReference>(artifactReferenceList.size());
        for (ArtifactReference ref : artifactReferenceList) {
            ret.add(ArchivaModelCloner.clone(ref));
        }
        return ret;
    }

    private static List<String> cloneSimpleStringList(List<String> simple) {
        if (simple == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>(simple.size());
        for (String txt : simple) {
            ret.add(txt);
        }
        return ret;
    }

    public static List<String> cloneAvailableVersions(List<String> availableVersions) {
        return ArchivaModelCloner.cloneSimpleStringList(availableVersions);
    }
}

