/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamLockfile {
    public static final String FILE_EXT = ".lockfile";
    private static final Logger logger = LoggerFactory.getLogger(StreamLockfile.class);
    private final File lockfile;

    public StreamLockfile(File directory, UUID uuid) {
        this.lockfile = new File(directory, uuid.toString() + FILE_EXT);
    }

    public StreamLockfile(File lockfile) {
        assert (lockfile != null);
        this.lockfile = lockfile;
    }

    public void create(Collection<SSTableWriter> sstables) {
        ArrayList<String> sstablePaths = new ArrayList<String>(sstables.size());
        for (SSTableWriter writer : sstables) {
            sstablePaths.add(writer.descriptor.asTemporary(false).baseFilename());
        }
        try {
            Files.write(this.lockfile.toPath(), sstablePaths, Charsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
        }
        catch (IOException e) {
            logger.warn(String.format("Could not create lockfile %s for stream session, nothing to worry too much about", this.lockfile), (Throwable)e);
        }
    }

    public void delete() {
        FileUtils.delete(this.lockfile);
    }

    public void cleanup() {
        List<String> files = this.readLockfile(this.lockfile);
        for (String file : files) {
            try {
                Descriptor desc = Descriptor.fromFilename(file, true);
                SSTable.delete(desc, SSTable.componentsFor(desc));
            }
            catch (Exception e) {
                logger.warn("failed to delete a potentially stale sstable {}", (Object)file);
            }
        }
    }

    private List<String> readLockfile(File lockfile) {
        try {
            return Files.readAllLines(lockfile.toPath(), Charsets.UTF_8);
        }
        catch (IOException e) {
            logger.info("couldn't read lockfile {}, ignoring", (Object)lockfile.getAbsolutePath());
            return Collections.emptyList();
        }
    }
}

