/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Memtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteredFlusher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MeteredFlusher.class);

    @Override
    public void run() {
        long allowedSize = MeteredFlusher.calculateAllowedSize();
        long flushingSize = MeteredFlusher.calculateFlushingSize();
        if (flushingSize > 0L) {
            logger.debug("Currently flushing {} bytes of {} max", (Object)flushingSize, (Object)allowedSize);
        }
        List<ColumnFamilyStore> affectedCFs = MeteredFlusher.affectedColumnFamilies();
        long liveSize = 0L;
        for (ColumnFamilyStore cfs : affectedCFs) {
            int maxInFlight = (int)Math.ceil((double)(2 + DatabaseDescriptor.getFlushWriters() + DatabaseDescriptor.getFlushQueueSize()) / (double)(1 + cfs.indexManager.getIndexesBackedByCfs().size()));
            long size = cfs.getTotalMemtableLiveSize();
            if (allowedSize > flushingSize && size > (allowedSize - flushingSize) / (long)maxInFlight) {
                logger.info("flushing high-traffic column family {} (estimated {} bytes)", (Object)cfs, (Object)size);
                cfs.forceFlush();
                continue;
            }
            liveSize += size;
        }
        if (liveSize + flushingSize <= allowedSize) {
            return;
        }
        logger.info("estimated {} live and {} flushing bytes used by all memtables", (Object)liveSize, (Object)flushingSize);
        Collections.sort(affectedCFs, new Comparator<ColumnFamilyStore>(){

            @Override
            public int compare(ColumnFamilyStore lhs, ColumnFamilyStore rhs) {
                return Long.compare(lhs.getTotalMemtableLiveSize(), rhs.getTotalMemtableLiveSize());
            }
        });
        while (!affectedCFs.isEmpty() && liveSize + (flushingSize = MeteredFlusher.calculateFlushingSize()) > allowedSize) {
            ColumnFamilyStore cfs = affectedCFs.remove(affectedCFs.size() - 1);
            long size = cfs.getTotalMemtableLiveSize();
            if (size <= 0L) continue;
            logger.info("flushing {} to free up {} bytes", (Object)cfs, (Object)size);
            liveSize -= size;
            cfs.forceFlush();
        }
        logger.trace("memtable memory usage is {} bytes with {} live", (Object)(liveSize + flushingSize), (Object)liveSize);
    }

    private static List<ColumnFamilyStore> affectedColumnFamilies() {
        ArrayList<ColumnFamilyStore> affected = new ArrayList<ColumnFamilyStore>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (!cfs.getCompactionStrategy().isAffectedByMeteredFlusher()) continue;
            affected.add(cfs);
        }
        return affected;
    }

    private static long calculateAllowedSize() {
        long allowed = (long)DatabaseDescriptor.getTotalMemtableSpaceInMB() * 0x100000L;
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (cfs.getCompactionStrategy().isAffectedByMeteredFlusher()) continue;
            allowed -= cfs.getCompactionStrategy().getMemtableReservedSize();
        }
        return allowed;
    }

    private static long calculateFlushingSize() {
        ColumnFamilyStore measuredCFS = Memtable.activelyMeasuring;
        long flushing = measuredCFS != null && measuredCFS.getCompactionStrategy().isAffectedByMeteredFlusher() ? measuredCFS.getMemtableThreadSafe().getLiveSize() : 0L;
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (!cfs.getCompactionStrategy().isAffectedByMeteredFlusher()) continue;
            for (Memtable memtable : cfs.getMemtablesPendingFlush()) {
                flushing += memtable.getLiveSize();
            }
        }
        return flushing;
    }
}

