/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.SingleColumnRestriction;
import org.apache.cassandra.exceptions.InvalidRequestException;

public interface MultiColumnRestriction
extends Restriction {

    public static class Slice
    extends SingleColumnRestriction.Slice
    implements MultiColumnRestriction {
        public Slice(boolean onToken) {
            super(onToken);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public ByteBuffer bound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
            throw new UnsupportedOperationException("Multicolumn slice restrictions do not support bound()");
        }

        public List<ByteBuffer> componentBounds(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
            Tuples.Value value = (Tuples.Value)this.bounds[b.idx].bind(variables);
            return value.getElements();
        }
    }

    public static class InWithMarker
    extends SingleColumnRestriction.InWithMarker
    implements IN {
        public InWithMarker(AbstractMarker marker) {
            super(marker);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<List<ByteBuffer>> splitValues(List<ByteBuffer> variables) throws InvalidRequestException {
            Term.Terminal inValue = ((Tuples.InMarker)this.marker).bind((List)variables);
            if (inValue == null) {
                throw new InvalidRequestException("Invalid null value for IN restriction");
            }
            return ((Tuples.InValue)inValue).getSplitValues();
        }
    }

    public static class InWithValues
    extends SingleColumnRestriction.InWithValues
    implements IN {
        public InWithValues(List<Term> values) {
            super(values);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<List<ByteBuffer>> splitValues(List<ByteBuffer> variables) throws InvalidRequestException {
            ArrayList<List<ByteBuffer>> buffers = new ArrayList<List<ByteBuffer>>(this.values.size());
            for (Term value : this.values) {
                Term.MultiItemTerminal term = (Term.MultiItemTerminal)value.bind(variables);
                buffers.add(term.getElements());
            }
            return buffers;
        }
    }

    public static interface IN
    extends MultiColumnRestriction {
        public List<List<ByteBuffer>> splitValues(List<ByteBuffer> var1) throws InvalidRequestException;
    }

    public static class EQ
    extends SingleColumnRestriction.EQ
    implements MultiColumnRestriction {
        public EQ(Term value, boolean onToken) {
            super(value, onToken);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            Tuples.Value t = (Tuples.Value)this.value.bind(variables);
            return t.getElements();
        }
    }
}

