/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.keys.jdo.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.archiva.redback.keys.jdo.AuthenticationKeyDatabase;
import org.apache.archiva.redback.keys.jdo.JdoAuthenticationKey;
import org.apache.archiva.redback.keys.jdo.io.stax.IndentingXMLStreamWriter;

public class RedbackKeyManagementJdoStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, AuthenticationKeyDatabase authenticationKeyDatabase) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(authenticationKeyDatabase.getModelEncoding(), "1.0");
        this.writeAuthenticationKeyDatabase(authenticationKeyDatabase, "authenticationKeyDatabase", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, AuthenticationKeyDatabase authenticationKeyDatabase) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, authenticationKeyDatabase.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(authenticationKeyDatabase.getModelEncoding(), "1.0");
        this.writeAuthenticationKeyDatabase(authenticationKeyDatabase, "authenticationKeyDatabase", serializer);
        serializer.writeEndDocument();
    }

    private void writeAuthenticationKeyDatabase(AuthenticationKeyDatabase authenticationKeyDatabase, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (authenticationKeyDatabase != null) {
            serializer.writeStartElement(tagName);
            if (authenticationKeyDatabase.getKeys() != null && authenticationKeyDatabase.getKeys().size() > 0) {
                serializer.writeStartElement("keys");
                for (JdoAuthenticationKey o : authenticationKeyDatabase.getKeys()) {
                    this.writeJdoAuthenticationKey(o, "key", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeJdoAuthenticationKey(JdoAuthenticationKey jdoAuthenticationKey, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoAuthenticationKey != null) {
            serializer.writeStartElement(tagName);
            if (jdoAuthenticationKey.getKey() != null) {
                serializer.writeStartElement("key");
                serializer.writeCharacters(jdoAuthenticationKey.getKey());
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getForPrincipal() != null) {
                serializer.writeStartElement("forPrincipal");
                serializer.writeCharacters(jdoAuthenticationKey.getForPrincipal());
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getPurpose() != null) {
                serializer.writeStartElement("purpose");
                serializer.writeCharacters(jdoAuthenticationKey.getPurpose());
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getDateCreated() != null) {
                serializer.writeStartElement("dateCreated");
                serializer.writeCharacters(String.valueOf(jdoAuthenticationKey.getDateCreated().getTime()));
                serializer.writeEndElement();
            }
            if (jdoAuthenticationKey.getDateExpires() != null) {
                serializer.writeStartElement("dateExpires");
                serializer.writeCharacters(String.valueOf(jdoAuthenticationKey.getDateExpires().getTime()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

