/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.role.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelOperation;
import org.apache.archiva.redback.role.model.ModelResource;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.ModelTemplate;
import org.apache.archiva.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

public class RoleModelUtils {
    public static List<ModelRole> getRoles(RedbackRoleModel model) {
        ArrayList<ModelRole> roleList = new ArrayList<ModelRole>();
        for (ModelApplication application : model.getApplications()) {
            roleList.addAll(application.getRoles());
        }
        return roleList;
    }

    public static List<ModelTemplate> getTemplates(RedbackRoleModel model) {
        ArrayList<ModelTemplate> templateList = new ArrayList<ModelTemplate>();
        for (ModelApplication application : model.getApplications()) {
            templateList.addAll(application.getTemplates());
        }
        return templateList;
    }

    public static List<String> getOperationIdList(RedbackRoleModel model) {
        ArrayList<String> operationsIdList = new ArrayList<String>();
        for (ModelApplication application : model.getApplications()) {
            for (ModelOperation operation : application.getOperations()) {
                operationsIdList.add(operation.getId());
            }
        }
        return operationsIdList;
    }

    public static List<String> getResourceIdList(RedbackRoleModel model) {
        ArrayList<String> resourceIdList = new ArrayList<String>();
        for (ModelApplication application : model.getApplications()) {
            for (ModelResource resource : application.getResources()) {
                resourceIdList.add(resource.getId());
            }
        }
        return resourceIdList;
    }

    public static List<String> getRoleIdList(RedbackRoleModel model) {
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (ModelApplication application : model.getApplications()) {
            for (ModelRole role : application.getRoles()) {
                roleIdList.add(role.getId());
            }
        }
        return roleIdList;
    }

    public static List<String> getTemplateIdList(RedbackRoleModel model) {
        ArrayList<String> templateIdList = new ArrayList<String>();
        for (ModelApplication application : model.getApplications()) {
            for (ModelTemplate template : application.getTemplates()) {
                templateIdList.add(template.getId());
            }
        }
        return templateIdList;
    }

    public static ModelRole getModelRole(RedbackRoleModel model, String roleId) {
        ModelRole mrole = null;
        for (ModelApplication application : model.getApplications()) {
            for (ModelRole role : application.getRoles()) {
                if (!roleId.equals(role.getId())) continue;
                mrole = role;
            }
        }
        return mrole;
    }

    public static ModelTemplate getModelTemplate(RedbackRoleModel model, String templateId) {
        ModelTemplate mtemplate = null;
        for (ModelApplication application : model.getApplications()) {
            for (ModelTemplate template : application.getTemplates()) {
                if (!templateId.equals(template.getId())) continue;
                mtemplate = template;
            }
        }
        return mtemplate;
    }

    public static ModelOperation getModelOperation(RedbackRoleModel model, String operationId) {
        ModelOperation moperation = null;
        for (ModelApplication application : model.getApplications()) {
            for (ModelOperation operation : application.getOperations()) {
                if (!operationId.equals(operation.getId())) continue;
                moperation = operation;
            }
        }
        return moperation;
    }

    public static ModelResource getModelResource(RedbackRoleModel model, String resourceId) {
        ModelResource mresource = null;
        for (ModelApplication application : model.getApplications()) {
            for (ModelResource resource : application.getResources()) {
                if (!resourceId.equals(resource.getId())) continue;
                mresource = resource;
            }
        }
        return mresource;
    }

    public static DAG generateRoleGraph(RedbackRoleModel model) throws CycleDetectedException {
        DAG roleGraph = new DAG();
        for (ModelApplication application : model.getApplications()) {
            for (ModelRole role : application.getRoles()) {
                roleGraph.addVertex(role.getId());
                if (role.getChildRoles() != null) {
                    for (String childRole : role.getChildRoles()) {
                        roleGraph.addVertex(childRole);
                        roleGraph.addEdge(role.getId(), childRole);
                    }
                }
                if (role.getParentRoles() == null) continue;
                for (String parentRole : role.getParentRoles()) {
                    roleGraph.addVertex(parentRole);
                    roleGraph.addEdge(parentRole, role.getId());
                }
            }
        }
        return roleGraph;
    }

    public static DAG generateTemplateGraph(RedbackRoleModel model) throws CycleDetectedException {
        DAG templateGraph = RoleModelUtils.generateRoleGraph(model);
        for (ModelApplication application : model.getApplications()) {
            for (ModelTemplate template : application.getTemplates()) {
                templateGraph.addVertex(template.getId());
                if (template.getChildRoles() != null) {
                    for (String childRole : template.getChildRoles()) {
                        templateGraph.addVertex(childRole);
                        templateGraph.addEdge(template.getId(), childRole);
                    }
                }
                if (template.getParentRoles() != null) {
                    for (String parentRole : template.getParentRoles()) {
                        templateGraph.addVertex(parentRole);
                        templateGraph.addEdge(parentRole, template.getId());
                    }
                }
                if (template.getChildTemplates() != null) {
                    for (String childTemplate : template.getChildTemplates()) {
                        templateGraph.addVertex(childTemplate);
                        templateGraph.addEdge(template.getId(), childTemplate);
                    }
                }
                if (template.getParentTemplates() == null) continue;
                for (String parentTemplate : template.getParentTemplates()) {
                    templateGraph.addVertex(parentTemplate);
                    templateGraph.addEdge(parentTemplate, template.getId());
                }
            }
        }
        return templateGraph;
    }

    public static List<String> reverseTopologicalSortedRoleList(RedbackRoleModel model) throws CycleDetectedException {
        LinkedList sortedGraph = (LinkedList)TopologicalSorter.sort((DAG)RoleModelUtils.generateRoleGraph(model));
        LinkedList<String> resortedGraph = new LinkedList<String>();
        while (!sortedGraph.isEmpty()) {
            resortedGraph.add((String)sortedGraph.removeLast());
        }
        return resortedGraph;
    }
}

