/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.role.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelOperation;
import org.apache.archiva.redback.role.model.ModelPermission;
import org.apache.archiva.redback.role.model.ModelResource;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.RedbackRoleModel;
import org.apache.archiva.redback.role.processor.RoleModelProcessor;
import org.apache.archiva.redback.role.util.RoleModelUtils;
import org.apache.commons.lang.time.StopWatch;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="roleModelProcessor")
public class DefaultRoleModelProcessor
implements RoleModelProcessor {
    private Logger log = LoggerFactory.getLogger(DefaultRoleModelProcessor.class);
    @Inject
    @Named(value="rbacManager#default")
    private RBACManager rbacManager;
    private Map<String, Resource> resourceMap = new HashMap<String, Resource>();
    private Map<String, Operation> operationMap = new HashMap<String, Operation>();

    @Override
    public void process(RedbackRoleModel model) throws RoleManagerException {
        this.processResources(model);
        this.processOperations(model);
        this.processRoles(model);
    }

    private void processResources(RedbackRoleModel model) throws RoleManagerException {
        for (ModelApplication application : model.getApplications()) {
            for (ModelResource profileResource : application.getResources()) {
                try {
                    if (!this.rbacManager.resourceExists(profileResource.getName())) {
                        Resource resource = this.rbacManager.createResource(profileResource.getName());
                        resource.setPermanent(profileResource.isPermanent());
                        resource = this.rbacManager.saveResource(resource);
                        this.resourceMap.put(profileResource.getId(), resource);
                        continue;
                    }
                    this.resourceMap.put(profileResource.getId(), this.rbacManager.getResource(profileResource.getName()));
                }
                catch (RbacManagerException e) {
                    throw new RoleManagerException("error creating resource '" + profileResource.getName() + "'", e);
                }
            }
        }
    }

    private void processOperations(RedbackRoleModel model) throws RoleManagerException {
        for (ModelApplication application : model.getApplications()) {
            for (ModelOperation profileOperation : application.getOperations()) {
                try {
                    if (!this.rbacManager.operationExists(profileOperation.getName())) {
                        Operation operation = this.rbacManager.createOperation(profileOperation.getName());
                        operation.setPermanent(profileOperation.isPermanent());
                        operation.setDescription(profileOperation.getDescription());
                        operation = this.rbacManager.saveOperation(operation);
                        this.operationMap.put(profileOperation.getId(), operation);
                        continue;
                    }
                    this.operationMap.put(profileOperation.getId(), this.rbacManager.getOperation(profileOperation.getName()));
                }
                catch (RbacManagerException e) {
                    throw new RoleManagerException("error creating operation '" + profileOperation.getName() + "'", e);
                }
            }
        }
    }

    private void processRoles(RedbackRoleModel model) throws RoleManagerException {
        List allRoles;
        List<String> sortedGraph;
        StopWatch stopWatch = new StopWatch();
        stopWatch.reset();
        stopWatch.start();
        try {
            sortedGraph = RoleModelUtils.reverseTopologicalSortedRoleList(model);
        }
        catch (CycleDetectedException e) {
            throw new RoleManagerException("cycle detected: this should have been caught in validation", e);
        }
        try {
            allRoles = this.rbacManager.getAllRoles();
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException(e.getMessage(), e);
        }
        HashSet<String> allRoleNames = new HashSet<String>(allRoles.size());
        for (Role role : allRoles) {
            allRoleNames.add(role.getName());
        }
        for (String roleId : sortedGraph) {
            Role role;
            ModelRole roleProfile = RoleModelUtils.getModelRole(model, roleId);
            List<Permission> permissions = this.processPermissions(roleProfile.getPermissions());
            boolean roleExists = allRoleNames.contains(roleProfile.getName());
            if (!roleExists) {
                try {
                    role = this.rbacManager.createRole(roleProfile.getName());
                    role.setDescription(roleProfile.getDescription());
                    role.setPermanent(roleProfile.isPermanent());
                    role.setAssignable(roleProfile.isAssignable());
                    for (Permission permission : permissions) {
                        role.addPermission(permission);
                    }
                    if (roleProfile.getChildRoles() != null) {
                        for (String string : roleProfile.getChildRoles()) {
                            ModelRole childRoleProfile = RoleModelUtils.getModelRole(model, string);
                            role.addChildRoleName(childRoleProfile.getName());
                        }
                    }
                    this.rbacManager.saveRole(role);
                    allRoleNames.add(role.getName());
                    if (roleProfile.getParentRoles() == null) continue;
                    for (String string : roleProfile.getParentRoles()) {
                        ModelRole parentModelRole = RoleModelUtils.getModelRole(model, string);
                        Role parentRole = this.rbacManager.getRole(parentModelRole.getName());
                        parentRole.addChildRoleName(role.getName());
                        this.rbacManager.saveRole(parentRole);
                        allRoleNames.add(parentRole.getName());
                    }
                    continue;
                }
                catch (RbacManagerException e) {
                    throw new RoleManagerException("error creating role '" + roleProfile.getName() + "'", e);
                }
            }
            try {
                role = this.rbacManager.getRole(roleProfile.getName());
                boolean changed = false;
                for (Permission permission : permissions) {
                    if (role.getPermissions().contains(permission)) continue;
                    this.log.info("Adding new permission '{}' to role '{}'", (Object)permission.getName(), (Object)role.getName());
                    role.addPermission(permission);
                    changed = true;
                }
                ArrayList arrayList = new ArrayList(role.getPermissions());
                for (Permission permission : arrayList) {
                    if (permissions.contains(permission)) continue;
                    this.log.info("Removing old permission '{}' from role '{}'", (Object)permission.getName(), (Object)role.getName());
                    role.removePermission(permission);
                    changed = true;
                }
                if (!changed) continue;
                this.rbacManager.saveRole(role);
                allRoleNames.add(role.getName());
            }
            catch (RbacManagerException e) {
                throw new RoleManagerException("error updating role '" + roleProfile.getName() + "'", e);
            }
        }
        stopWatch.stop();
        this.log.info("time to process roles model: {} ms", (Object)stopWatch.getTime());
    }

    private List<Permission> processPermissions(List<ModelPermission> permissions) throws RoleManagerException {
        ArrayList<Permission> rbacPermissions = new ArrayList<Permission>(permissions.size());
        for (ModelPermission profilePermission : permissions) {
            try {
                if (!this.rbacManager.permissionExists(profilePermission.getName())) {
                    Permission permission = this.rbacManager.createPermission(profilePermission.getName());
                    Operation operation = this.operationMap.get(profilePermission.getOperation());
                    Resource resource = this.resourceMap.get(profilePermission.getResource());
                    permission.setOperation(operation);
                    permission.setResource(resource);
                    permission.setPermanent(profilePermission.isPermanent());
                    permission.setDescription(profilePermission.getDescription());
                    permission = this.rbacManager.savePermission(permission);
                    rbacPermissions.add(permission);
                    continue;
                }
                rbacPermissions.add(this.rbacManager.getPermission(profilePermission.getName()));
            }
            catch (RbacManagerException e) {
                throw new RoleManagerException("error creating permission '" + profilePermission.getName() + "'", e);
            }
        }
        return rbacPermissions;
    }

    public RBACManager getRbacManager() {
        return this.rbacManager;
    }

    public void setRbacManager(RBACManager rbacManager) {
        this.rbacManager = rbacManager;
    }
}

