/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.role.model.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelOperation;
import org.apache.archiva.redback.role.model.ModelPermission;
import org.apache.archiva.redback.role.model.ModelResource;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.ModelTemplate;
import org.apache.archiva.redback.role.model.RedbackRoleModel;
import org.apache.archiva.redback.role.model.io.stax.IndentingXMLStreamWriter;

public class RedbackRoleModelStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, RedbackRoleModel redbackRoleModel) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(redbackRoleModel.getModelEncoding(), "1.0");
        this.writeRedbackRoleModel(redbackRoleModel, "redback-role-model", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, RedbackRoleModel redbackRoleModel) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, redbackRoleModel.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(redbackRoleModel.getModelEncoding(), "1.0");
        this.writeRedbackRoleModel(redbackRoleModel, "redback-role-model", serializer);
        serializer.writeEndDocument();
    }

    private void writeModelApplication(ModelApplication modelApplication, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelApplication != null) {
            serializer.writeStartElement(tagName);
            if (modelApplication.getVersion() != null) {
                serializer.writeStartElement("version");
                serializer.writeCharacters(modelApplication.getVersion());
                serializer.writeEndElement();
            }
            if (modelApplication.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(modelApplication.getId());
                serializer.writeEndElement();
            }
            if (modelApplication.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(modelApplication.getDescription());
                serializer.writeEndElement();
            }
            if (modelApplication.getLongDescription() != null) {
                serializer.writeStartElement("longDescription");
                serializer.writeCharacters(modelApplication.getLongDescription());
                serializer.writeEndElement();
            }
            if (modelApplication.getResources() != null && modelApplication.getResources().size() > 0) {
                serializer.writeStartElement("resources");
                for (ModelResource modelResource : modelApplication.getResources()) {
                    this.writeModelResource(modelResource, "resource", serializer);
                }
                serializer.writeEndElement();
            }
            if (modelApplication.getOperations() != null && modelApplication.getOperations().size() > 0) {
                serializer.writeStartElement("operations");
                for (ModelOperation modelOperation : modelApplication.getOperations()) {
                    this.writeModelOperation(modelOperation, "operation", serializer);
                }
                serializer.writeEndElement();
            }
            if (modelApplication.getRoles() != null && modelApplication.getRoles().size() > 0) {
                serializer.writeStartElement("roles");
                for (ModelRole modelRole : modelApplication.getRoles()) {
                    this.writeModelRole(modelRole, "role", serializer);
                }
                serializer.writeEndElement();
            }
            if (modelApplication.getTemplates() != null && modelApplication.getTemplates().size() > 0) {
                serializer.writeStartElement("templates");
                for (ModelTemplate modelTemplate : modelApplication.getTemplates()) {
                    this.writeModelTemplate(modelTemplate, "template", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeModelOperation(ModelOperation modelOperation, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelOperation != null) {
            serializer.writeStartElement(tagName);
            if (modelOperation.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(modelOperation.getId());
                serializer.writeEndElement();
            }
            if (modelOperation.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(modelOperation.getName());
                serializer.writeEndElement();
            }
            if (modelOperation.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(modelOperation.getDescription());
                serializer.writeEndElement();
            }
            if (modelOperation.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(modelOperation.isPermanent()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeModelPermission(ModelPermission modelPermission, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelPermission != null) {
            serializer.writeStartElement(tagName);
            if (modelPermission.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(modelPermission.getId());
                serializer.writeEndElement();
            }
            if (modelPermission.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(modelPermission.getName());
                serializer.writeEndElement();
            }
            if (modelPermission.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(modelPermission.getDescription());
                serializer.writeEndElement();
            }
            if (modelPermission.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(modelPermission.isPermanent()));
                serializer.writeEndElement();
            }
            if (modelPermission.getOperation() != null) {
                serializer.writeStartElement("operation");
                serializer.writeCharacters(modelPermission.getOperation());
                serializer.writeEndElement();
            }
            if (modelPermission.getResource() != null) {
                serializer.writeStartElement("resource");
                serializer.writeCharacters(modelPermission.getResource());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeModelResource(ModelResource modelResource, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelResource != null) {
            serializer.writeStartElement(tagName);
            if (modelResource.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(modelResource.getId());
                serializer.writeEndElement();
            }
            if (modelResource.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(modelResource.getName());
                serializer.writeEndElement();
            }
            if (modelResource.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(modelResource.isPermanent()));
                serializer.writeEndElement();
            }
            if (modelResource.isPattern()) {
                serializer.writeStartElement("pattern");
                serializer.writeCharacters(String.valueOf(modelResource.isPattern()));
                serializer.writeEndElement();
            }
            if (modelResource.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(modelResource.getDescription());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeModelRole(ModelRole modelRole, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelRole != null) {
            serializer.writeStartElement(tagName);
            if (modelRole.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(modelRole.getId());
                serializer.writeEndElement();
            }
            if (modelRole.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(modelRole.getName());
                serializer.writeEndElement();
            }
            if (modelRole.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(modelRole.getDescription());
                serializer.writeEndElement();
            }
            if (modelRole.isAssignable()) {
                serializer.writeStartElement("assignable");
                serializer.writeCharacters(String.valueOf(modelRole.isAssignable()));
                serializer.writeEndElement();
            }
            if (modelRole.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(modelRole.isPermanent()));
                serializer.writeEndElement();
            }
            if (modelRole.getPermissions() != null && modelRole.getPermissions().size() > 0) {
                serializer.writeStartElement("permissions");
                for (ModelPermission o : modelRole.getPermissions()) {
                    this.writeModelPermission(o, "permission", serializer);
                }
                serializer.writeEndElement();
            }
            if (modelRole.getParentRoles() != null && modelRole.getParentRoles().size() > 0) {
                serializer.writeStartElement("parentRoles");
                for (String parentRole : modelRole.getParentRoles()) {
                    serializer.writeStartElement("parentRole");
                    serializer.writeCharacters(parentRole);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (modelRole.getChildRoles() != null && modelRole.getChildRoles().size() > 0) {
                serializer.writeStartElement("childRoles");
                for (String childRole : modelRole.getChildRoles()) {
                    serializer.writeStartElement("childRole");
                    serializer.writeCharacters(childRole);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeModelTemplate(ModelTemplate modelTemplate, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelTemplate != null) {
            serializer.writeStartElement(tagName);
            if (modelTemplate.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(modelTemplate.getId());
                serializer.writeEndElement();
            }
            if (modelTemplate.getNamePrefix() != null) {
                serializer.writeStartElement("namePrefix");
                serializer.writeCharacters(modelTemplate.getNamePrefix());
                serializer.writeEndElement();
            }
            if (modelTemplate.getDelimiter() != null && !modelTemplate.getDelimiter().equals(" - ")) {
                serializer.writeStartElement("delimiter");
                serializer.writeCharacters(modelTemplate.getDelimiter());
                serializer.writeEndElement();
            }
            if (modelTemplate.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(modelTemplate.getDescription());
                serializer.writeEndElement();
            }
            if (modelTemplate.isAssignable()) {
                serializer.writeStartElement("assignable");
                serializer.writeCharacters(String.valueOf(modelTemplate.isAssignable()));
                serializer.writeEndElement();
            }
            if (modelTemplate.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(modelTemplate.isPermanent()));
                serializer.writeEndElement();
            }
            if (modelTemplate.isPermanentResource()) {
                serializer.writeStartElement("permanentResource");
                serializer.writeCharacters(String.valueOf(modelTemplate.isPermanentResource()));
                serializer.writeEndElement();
            }
            if (modelTemplate.getPermissions() != null && modelTemplate.getPermissions().size() > 0) {
                serializer.writeStartElement("permissions");
                for (ModelPermission o : modelTemplate.getPermissions()) {
                    this.writeModelPermission(o, "permission", serializer);
                }
                serializer.writeEndElement();
            }
            if (modelTemplate.getParentRoles() != null && modelTemplate.getParentRoles().size() > 0) {
                serializer.writeStartElement("parentRoles");
                for (String parentRole : modelTemplate.getParentRoles()) {
                    serializer.writeStartElement("parentRole");
                    serializer.writeCharacters(parentRole);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (modelTemplate.getChildRoles() != null && modelTemplate.getChildRoles().size() > 0) {
                serializer.writeStartElement("childRoles");
                for (String childRole : modelTemplate.getChildRoles()) {
                    serializer.writeStartElement("childRole");
                    serializer.writeCharacters(childRole);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (modelTemplate.getParentTemplates() != null && modelTemplate.getParentTemplates().size() > 0) {
                serializer.writeStartElement("parentTemplates");
                for (String parentTemplate : modelTemplate.getParentTemplates()) {
                    serializer.writeStartElement("parentTemplate");
                    serializer.writeCharacters(parentTemplate);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (modelTemplate.getChildTemplates() != null && modelTemplate.getChildTemplates().size() > 0) {
                serializer.writeStartElement("childTemplates");
                for (String childTemplate : modelTemplate.getChildTemplates()) {
                    serializer.writeStartElement("childTemplate");
                    serializer.writeCharacters(childTemplate);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeRedbackRoleModel(RedbackRoleModel redbackRoleModel, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (redbackRoleModel != null) {
            serializer.setDefaultNamespace("http://archiva.apache.org/redback/role/1.0.0");
            serializer.writeStartElement(tagName);
            serializer.writeDefaultNamespace("http://archiva.apache.org/redback/role/1.0.0");
            if (redbackRoleModel.getModelVersion() != null) {
                serializer.writeStartElement("modelVersion");
                serializer.writeCharacters(redbackRoleModel.getModelVersion());
                serializer.writeEndElement();
            }
            if (redbackRoleModel.getApplications() != null && redbackRoleModel.getApplications().size() > 0) {
                serializer.writeStartElement("applications");
                for (ModelApplication o : redbackRoleModel.getApplications()) {
                    this.writeModelApplication(o, "application", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

