/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.role.model.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelOperation;
import org.apache.archiva.redback.role.model.ModelPermission;
import org.apache.archiva.redback.role.model.ModelResource;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.ModelTemplate;
import org.apache.archiva.redback.role.model.RedbackRoleModel;

public class RedbackRoleModelStaxReader {
    public RedbackRoleModel read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        return this.read(xmlStreamReader, strict);
    }

    public RedbackRoleModel read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public RedbackRoleModel read(InputStream stream, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
        return this.read(xmlStreamReader, strict);
    }

    public RedbackRoleModel read(InputStream stream) throws IOException, XMLStreamException {
        return this.read(stream, true);
    }

    public RedbackRoleModel read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURI().toURL().toExternalForm(), new FileInputStream(file));
        return this.read(xmlStreamReader, strict);
    }

    public RedbackRoleModel read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private boolean checkFieldWithDuplicate(XMLStreamReader xmlStreamReader, String tagName, String alias, Set parsed) throws XMLStreamException {
        if (!xmlStreamReader.getLocalName().equals(tagName) && !xmlStreamReader.getLocalName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation());
        }
        return true;
    }

    private void checkUnknownElement(XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount != 0) {
            xmlStreamReader.next();
            if (xmlStreamReader.getEventType() == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (xmlStreamReader.getEventType() != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
            }
        }
        return null;
    }

    private String getDefaultValue(String s, String v) {
        if (s == null) {
            s = v;
        }
        return s;
    }

    private double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int nextTag(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        block4: while (true) {
            int eventType = xmlStreamReader.next();
            switch (eventType) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return eventType;
                }
            }
            break;
        }
        throw new XMLStreamException("expected start or end tag", xmlStreamReader.getLocation());
    }

    private ModelApplication parseModelApplication(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ModelApplication modelApplication = new ModelApplication();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "version", null, parsed)) {
                modelApplication.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "id", null, parsed)) {
                modelApplication.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                modelApplication.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "longDescription", null, parsed)) {
                modelApplication.setLongDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "resources", null, parsed)) {
                ArrayList<ModelResource> resources = new ArrayList<ModelResource>();
                modelApplication.setResources(resources);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("resource".equals(xmlStreamReader.getLocalName())) {
                        modelApplication.addResource(this.parseModelResource(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "operations", null, parsed)) {
                ArrayList<ModelOperation> operations = new ArrayList<ModelOperation>();
                modelApplication.setOperations(operations);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("operation".equals(xmlStreamReader.getLocalName())) {
                        modelApplication.addOperation(this.parseModelOperation(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "roles", null, parsed)) {
                ArrayList<ModelRole> roles = new ArrayList<ModelRole>();
                modelApplication.setRoles(roles);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("role".equals(xmlStreamReader.getLocalName())) {
                        modelApplication.addRole(this.parseModelRole(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "templates", null, parsed)) {
                ArrayList<ModelTemplate> templates = new ArrayList<ModelTemplate>();
                modelApplication.setTemplates(templates);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("template".equals(xmlStreamReader.getLocalName())) {
                        modelApplication.addTemplate(this.parseModelTemplate(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return modelApplication;
    }

    private ModelOperation parseModelOperation(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ModelOperation modelOperation = new ModelOperation();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "id", null, parsed)) {
                modelOperation.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "name", null, parsed)) {
                modelOperation.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                modelOperation.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                modelOperation.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return modelOperation;
    }

    private ModelPermission parseModelPermission(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ModelPermission modelPermission = new ModelPermission();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "id", null, parsed)) {
                modelPermission.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "name", null, parsed)) {
                modelPermission.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                modelPermission.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                modelPermission.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "operation", null, parsed)) {
                modelPermission.setOperation(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "resource", null, parsed)) {
                modelPermission.setResource(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return modelPermission;
    }

    private ModelResource parseModelResource(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ModelResource modelResource = new ModelResource();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "id", null, parsed)) {
                modelResource.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "name", null, parsed)) {
                modelResource.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                modelResource.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "pattern", null, parsed)) {
                modelResource.setPattern(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "pattern", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                modelResource.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return modelResource;
    }

    private ModelRole parseModelRole(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ModelRole modelRole = new ModelRole();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "id", null, parsed)) {
                modelRole.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "name", null, parsed)) {
                modelRole.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                modelRole.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "assignable", null, parsed)) {
                modelRole.setAssignable(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "assignable", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                modelRole.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permissions", null, parsed)) {
                ArrayList<ModelPermission> permissions = new ArrayList<ModelPermission>();
                modelRole.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("permission".equals(xmlStreamReader.getLocalName())) {
                        modelRole.addPermission(this.parseModelPermission(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "parentRoles", null, parsed)) {
                ArrayList<String> parentRoles = new ArrayList<String>();
                modelRole.setParentRoles(parentRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("parentRole".equals(xmlStreamReader.getLocalName())) {
                        parentRoles.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "childRoles", null, parsed)) {
                ArrayList<String> childRoles = new ArrayList<String>();
                modelRole.setChildRoles(childRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("childRole".equals(xmlStreamReader.getLocalName())) {
                        childRoles.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return modelRole;
    }

    private ModelTemplate parseModelTemplate(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ModelTemplate modelTemplate = new ModelTemplate();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "id", null, parsed)) {
                modelTemplate.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "namePrefix", null, parsed)) {
                modelTemplate.setNamePrefix(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "delimiter", null, parsed)) {
                modelTemplate.setDelimiter(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), " - ")));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                modelTemplate.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "assignable", null, parsed)) {
                modelTemplate.setAssignable(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "assignable", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                modelTemplate.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanentResource", null, parsed)) {
                modelTemplate.setPermanentResource(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanentResource", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permissions", null, parsed)) {
                ArrayList<ModelPermission> permissions = new ArrayList<ModelPermission>();
                modelTemplate.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("permission".equals(xmlStreamReader.getLocalName())) {
                        modelTemplate.addPermission(this.parseModelPermission(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "parentRoles", null, parsed)) {
                ArrayList<String> parentRoles = new ArrayList<String>();
                modelTemplate.setParentRoles(parentRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("parentRole".equals(xmlStreamReader.getLocalName())) {
                        parentRoles.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "childRoles", null, parsed)) {
                ArrayList<String> childRoles = new ArrayList<String>();
                modelTemplate.setChildRoles(childRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("childRole".equals(xmlStreamReader.getLocalName())) {
                        childRoles.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "parentTemplates", null, parsed)) {
                ArrayList<String> parentTemplates = new ArrayList<String>();
                modelTemplate.setParentTemplates(parentTemplates);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("parentTemplate".equals(xmlStreamReader.getLocalName())) {
                        parentTemplates.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "childTemplates", null, parsed)) {
                ArrayList<String> childTemplates = new ArrayList<String>();
                modelTemplate.setChildTemplates(childTemplates);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("childTemplate".equals(xmlStreamReader.getLocalName())) {
                        childTemplates.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return modelTemplate;
    }

    private RedbackRoleModel parseRedbackRoleModel(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        RedbackRoleModel redbackRoleModel = new RedbackRoleModel();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "modelVersion", null, parsed)) {
                redbackRoleModel.setModelVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "applications", null, parsed)) {
                ArrayList<ModelApplication> applications = new ArrayList<ModelApplication>();
                redbackRoleModel.setApplications(applications);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("application".equals(xmlStreamReader.getLocalName())) {
                        redbackRoleModel.addApplication(this.parseModelApplication(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return redbackRoleModel;
    }

    private RedbackRoleModel read(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while (eventType != 8) {
            if (eventType == 7) {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if (eventType == 1) {
                if (strict && !"redback-role-model".equals(xmlStreamReader.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'redback-role-model' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null);
                }
                RedbackRoleModel redbackRoleModel = this.parseRedbackRoleModel(xmlStreamReader, strict);
                redbackRoleModel.setModelEncoding(encoding);
                this.resolveReferences(redbackRoleModel);
                return redbackRoleModel;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException("Expected root element 'redback-role-model' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null);
    }

    private void resolveReferences(RedbackRoleModel value) {
    }
}

