/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.role.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.redback.role.model.ModelPermission;

public class ModelRole
implements Serializable {
    private String id;
    private String name;
    private String description;
    private boolean assignable = false;
    private boolean permanent = false;
    private List<ModelPermission> permissions;
    private List<String> parentRoles;
    private List<String> childRoles;

    public void addChildRole(String string) {
        this.getChildRoles().add(string);
    }

    public void addParentRole(String string) {
        this.getParentRoles().add(string);
    }

    public void addPermission(ModelPermission modelPermission) {
        this.getPermissions().add(modelPermission);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelRole)) {
            return false;
        }
        ModelRole that = (ModelRole)other;
        boolean result = true;
        result = result && (this.getId() == null ? that.getId() == null : this.getId().equals(that.getId()));
        return result;
    }

    public List<String> getChildRoles() {
        if (this.childRoles == null) {
            this.childRoles = new ArrayList<String>();
        }
        return this.childRoles;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParentRoles() {
        if (this.parentRoles == null) {
            this.parentRoles = new ArrayList<String>();
        }
        return this.parentRoles;
    }

    public List<ModelPermission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<ModelPermission>();
        }
        return this.permissions;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void removeChildRole(String string) {
        this.getChildRoles().remove(string);
    }

    public void removeParentRole(String string) {
        this.getParentRoles().remove(string);
    }

    public void removePermission(ModelPermission modelPermission) {
        this.getPermissions().remove(modelPermission);
    }

    public void setAssignable(boolean assignable) {
        this.assignable = assignable;
    }

    public void setChildRoles(List<String> childRoles) {
        this.childRoles = childRoles;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentRoles(List<String> parentRoles) {
        this.parentRoles = parentRoles;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public void setPermissions(List<ModelPermission> permissions) {
        this.permissions = permissions;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("id = '");
        buf.append(this.getId());
        buf.append("'");
        return buf.toString();
    }
}

