/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.role;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.stream.XMLStreamException;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.ModelTemplate;
import org.apache.archiva.redback.role.model.RedbackRoleModel;
import org.apache.archiva.redback.role.model.io.stax.RedbackRoleModelStaxReader;
import org.apache.archiva.redback.role.processor.RoleModelProcessor;
import org.apache.archiva.redback.role.template.RoleTemplateProcessor;
import org.apache.archiva.redback.role.util.RoleModelUtils;
import org.apache.archiva.redback.role.validator.RoleModelValidator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="roleManager")
public class DefaultRoleManager
implements RoleManager {
    private Logger log = LoggerFactory.getLogger(DefaultRoleManager.class);
    private RedbackRoleModel blessedModel;
    private RedbackRoleModel unblessedModel;
    private Map<String, ModelApplication> knownResources = new HashMap<String, ModelApplication>();
    @Inject
    @Named(value="roleModelValidator")
    private RoleModelValidator modelValidator;
    @Inject
    @Named(value="roleModelProcessor")
    private RoleModelProcessor modelProcessor;
    @Inject
    @Named(value="roleTemplateProcessor")
    private RoleTemplateProcessor templateProcessor;
    @Inject
    @Named(value="rbacManager#default")
    private RBACManager rbacManager;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loadRoleModel(URL resource) throws RoleManagerException {
        RedbackRoleModelStaxReader reader = new RedbackRoleModelStaxReader();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(resource.openStream());
            RedbackRoleModel roleModel = reader.read(inputStreamReader);
            for (ModelApplication app : roleModel.getApplications()) {
                if (this.knownResources.containsKey(app.getId())) continue;
                this.log.info("loading {}", (Object)app.getId());
                this.loadApplication(app);
            }
        }
        catch (MalformedURLException e) {
            try {
                throw new RoleManagerException("error locating redback profile", e);
                catch (IOException e2) {
                    throw new RoleManagerException("error reading redback profile", e2);
                }
                catch (XMLStreamException e3) {
                    throw new RoleManagerException("error parsing redback profile", e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)inputStreamReader);
    }

    @Override
    public void loadRoleModel(RedbackRoleModel roleModel) throws RoleManagerException {
        for (ModelApplication app : roleModel.getApplications()) {
            if (this.knownResources.containsKey(app.getId())) continue;
            this.loadApplication(app);
        }
    }

    public void loadApplication(ModelApplication app) throws RoleManagerException {
        if (this.unblessedModel == null) {
            this.unblessedModel = new RedbackRoleModel();
        }
        this.unblessedModel.addApplication(app);
        if (!this.modelValidator.validate(this.unblessedModel)) {
            StringBuilder stringBuilder = new StringBuilder("Role Model Validation Errors:");
            for (String error : this.modelValidator.getValidationErrors()) {
                stringBuilder.append(error).append(SystemUtils.LINE_SEPARATOR);
            }
            this.log.error(stringBuilder.toString());
            throw new RoleManagerException("Role Model Validation Error " + SystemUtils.LINE_SEPARATOR + stringBuilder.toString());
        }
        this.blessedModel = this.unblessedModel;
        this.modelProcessor.process(this.blessedModel);
        this.knownResources.put(app.getId(), app);
    }

    @Override
    public void createTemplatedRole(String templateId, String resource) throws RoleManagerException {
        this.templateProcessor.create(this.blessedModel, templateId, resource);
    }

    @Override
    public void removeTemplatedRole(String templateId, String resource) throws RoleManagerException {
        ModelTemplate template = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        String roleName = template.getNamePrefix() + template.getDelimiter() + resource;
        try {
            Role role = this.rbacManager.getRole(roleName);
            for (UserAssignment assignment : this.rbacManager.getUserAssignmentsForRoles(Arrays.asList(role.getName()))) {
                assignment.removeRoleName(role);
                this.rbacManager.saveUserAssignment(assignment);
            }
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("unable to remove role", e);
        }
        this.templateProcessor.remove(this.blessedModel, templateId, resource);
    }

    @Override
    public void updateRole(String templateId, String oldResource, String newResource) throws RoleManagerException {
        this.templateProcessor.create(this.blessedModel, templateId, newResource);
        ModelTemplate template = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        String oldRoleName = template.getNamePrefix() + template.getDelimiter() + oldResource;
        String newRoleName = template.getNamePrefix() + template.getDelimiter() + newResource;
        try {
            Role role = this.rbacManager.getRole(oldRoleName);
            for (UserAssignment assignment : this.rbacManager.getUserAssignmentsForRoles(Arrays.asList(role.getName()))) {
                assignment.removeRoleName(oldRoleName);
                assignment.addRoleName(newRoleName);
                this.rbacManager.saveUserAssignment(assignment);
            }
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("unable to update role", e);
        }
        this.templateProcessor.remove(this.blessedModel, templateId, oldResource);
    }

    @Override
    public void assignRole(String roleId, String principal) throws RoleManagerException {
        ModelRole modelRole = RoleModelUtils.getModelRole(this.blessedModel, roleId);
        if (modelRole == null) {
            throw new RoleManagerException("Unable to assign role: " + roleId + " does not exist.");
        }
        try {
            UserAssignment userAssignment = this.rbacManager.userAssignmentExists(principal) ? this.rbacManager.getUserAssignment(principal) : this.rbacManager.createUserAssignment(principal);
            userAssignment.addRoleName(modelRole.getName());
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to assign role: unable to manage user assignment", e);
        }
    }

    @Override
    public void assignRoleByName(String roleName, String principal) throws RoleManagerException {
        try {
            UserAssignment userAssignment = this.rbacManager.userAssignmentExists(principal) ? this.rbacManager.getUserAssignment(principal) : this.rbacManager.createUserAssignment(principal);
            if (!this.rbacManager.roleExists(roleName)) {
                throw new RoleManagerException("Unable to assign role: " + roleName + " does not exist.");
            }
            userAssignment.addRoleName(roleName);
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to assign role: unable to manage user assignment", e);
        }
    }

    @Override
    public void assignTemplatedRole(String templateId, String resource, String principal) throws RoleManagerException {
        ModelTemplate modelTemplate = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        if (modelTemplate == null) {
            throw new RoleManagerException("Unable to assign role: " + templateId + " does not exist.");
        }
        try {
            if (!this.rbacManager.resourceExists(resource)) {
                Resource newResource = this.rbacManager.createResource(resource);
                this.rbacManager.saveResource(newResource);
            }
            UserAssignment userAssignment = this.rbacManager.userAssignmentExists(principal) ? this.rbacManager.getUserAssignment(principal) : this.rbacManager.createUserAssignment(principal);
            userAssignment.addRoleName(modelTemplate.getNamePrefix() + modelTemplate.getDelimiter() + resource);
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to assign role: unable to manage user assignment", e);
        }
    }

    @Override
    public void unassignRole(String roleId, String principal) throws RoleManagerException {
        ModelRole modelRole = RoleModelUtils.getModelRole(this.blessedModel, roleId);
        if (modelRole == null) {
            throw new RoleManagerException("Unable to assign role: " + roleId + " does not exist.");
        }
        try {
            if (!this.rbacManager.userAssignmentExists(principal)) {
                throw new RoleManagerException("UserAssignment for principal " + principal + "does not exist, can't unassign role.");
            }
            UserAssignment userAssignment = this.rbacManager.getUserAssignment(principal);
            userAssignment.removeRoleName(modelRole.getName());
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to unassign role: unable to manage user assignment", e);
        }
    }

    @Override
    public void unassignRoleByName(String roleName, String principal) throws RoleManagerException {
        try {
            if (!this.rbacManager.userAssignmentExists(principal)) {
                throw new RoleManagerException("UserAssignment for principal " + principal + "does not exist, can't unassign role.");
            }
            UserAssignment userAssignment = this.rbacManager.getUserAssignment(principal);
            if (!this.rbacManager.roleExists(roleName)) {
                throw new RoleManagerException("Unable to unassign role: " + roleName + " does not exist.");
            }
            userAssignment.removeRoleName(roleName);
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to unassign role: unable to manage user assignment", e);
        }
    }

    @Override
    public boolean roleExists(String roleId) throws RoleManagerException {
        ModelRole modelRole = RoleModelUtils.getModelRole(this.blessedModel, roleId);
        if (modelRole == null) {
            return false;
        }
        try {
            if (this.rbacManager.roleExists(modelRole.getName())) {
                return true;
            }
            throw new RoleManagerException("breakdown in role management, role '" + modelRole.getName() + "' exists in configuration but was not created in underlying store");
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException(e.getMessage(), e);
        }
    }

    @Override
    public boolean templatedRoleExists(String templateId, String resource) throws RoleManagerException {
        ModelTemplate modelTemplate = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        if (modelTemplate == null) {
            return false;
        }
        try {
            return this.rbacManager.roleExists(modelTemplate.getNamePrefix() + modelTemplate.getDelimiter() + resource);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException(e.getMessage(), e);
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.knownResources = new HashMap<String, ModelApplication>();
        this.unblessedModel = new RedbackRoleModel();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            URL baseResource = RoleManager.class.getResource("/META-INF/redback/redback-core.xml");
            if (baseResource == null) {
                throw new RuntimeException("unable to initialize role manager, missing redback-core.xml");
            }
            this.loadRoleModel(baseResource);
            Enumeration<URL> enumerator = RoleManager.class.getClassLoader().getResources("META-INF/redback/redback.xml");
            while (enumerator.hasMoreElements()) {
                URL redbackResource = enumerator.nextElement();
                this.loadRoleModel(redbackResource);
            }
        }
        catch (RoleManagerException e) {
            throw new RuntimeException("unable to initialize RoleManager", e);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to initialize RoleManager, problem with redback.xml loading", e);
        }
        stopWatch.stop();
        this.log.info("DefaultRoleManager initialize time {}", (Object)stopWatch.getTime());
    }

    @Override
    public RedbackRoleModel getModel() {
        return this.blessedModel;
    }

    @Override
    public void verifyTemplatedRole(String templateId, String resource) throws RoleManagerException {
        this.templateProcessor.create(this.blessedModel, templateId, resource);
    }

    public RedbackRoleModel getBlessedModel() {
        return this.blessedModel;
    }

    public void setBlessedModel(RedbackRoleModel blessedModel) {
        this.blessedModel = blessedModel;
    }

    public RedbackRoleModel getUnblessedModel() {
        return this.unblessedModel;
    }

    public void setUnblessedModel(RedbackRoleModel unblessedModel) {
        this.unblessedModel = unblessedModel;
    }

    public Map<String, ModelApplication> getKnownResources() {
        return this.knownResources;
    }

    public void setKnownResources(Map<String, ModelApplication> knownResources) {
        this.knownResources = knownResources;
    }

    public RoleModelValidator getModelValidator() {
        return this.modelValidator;
    }

    public void setModelValidator(RoleModelValidator modelValidator) {
        this.modelValidator = modelValidator;
    }

    public RoleModelProcessor getModelProcessor() {
        return this.modelProcessor;
    }

    public void setModelProcessor(RoleModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
    }

    public RoleTemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public void setTemplateProcessor(RoleTemplateProcessor templateProcessor) {
        this.templateProcessor = templateProcessor;
    }

    public RBACManager getRbacManager() {
        return this.rbacManager;
    }

    public void setRbacManager(RBACManager rbacManager) {
        this.rbacManager = rbacManager;
    }
}

