/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.stats;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.archiva.metadata.model.MetadataFacet;

public class RepositoryStatistics
implements MetadataFacet {
    private Date scanEndTime;
    private Date scanStartTime;
    private long totalArtifactCount;
    private long totalArtifactFileSize;
    private long totalFileCount;
    private long totalGroupCount;
    private long totalProjectCount;
    private long newFileCount;
    public static String FACET_ID = "org.apache.archiva.metadata.repository.stats";
    static final String SCAN_TIMESTAMP_FORMAT = "yyyy/MM/dd/HHmmss.SSS";
    private Map<String, Long> totalCountForType = new ZeroForNullHashMap<String, Long>();
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private String repositoryId;

    public Date getScanEndTime() {
        return this.scanEndTime;
    }

    public void setScanEndTime(Date scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public Date getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(Date scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public long getTotalArtifactCount() {
        return this.totalArtifactCount;
    }

    public void setTotalArtifactCount(long totalArtifactCount) {
        this.totalArtifactCount = totalArtifactCount;
    }

    public long getTotalArtifactFileSize() {
        return this.totalArtifactFileSize;
    }

    public void setTotalArtifactFileSize(long totalArtifactFileSize) {
        this.totalArtifactFileSize = totalArtifactFileSize;
    }

    public long getTotalFileCount() {
        return this.totalFileCount;
    }

    public void setTotalFileCount(long totalFileCount) {
        this.totalFileCount = totalFileCount;
    }

    public long getTotalGroupCount() {
        return this.totalGroupCount;
    }

    public void setTotalGroupCount(long totalGroupCount) {
        this.totalGroupCount = totalGroupCount;
    }

    public long getTotalProjectCount() {
        return this.totalProjectCount;
    }

    public void setTotalProjectCount(long totalProjectCount) {
        this.totalProjectCount = totalProjectCount;
    }

    public void setNewFileCount(long newFileCount) {
        this.newFileCount = newFileCount;
    }

    public long getNewFileCount() {
        return this.newFileCount;
    }

    public long getDuration() {
        return this.scanEndTime.getTime() - this.scanStartTime.getTime();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getFacetId() {
        return FACET_ID;
    }

    public String getName() {
        return RepositoryStatistics.createNameFormat().format(this.scanStartTime);
    }

    private static SimpleDateFormat createNameFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat(SCAN_TIMESTAMP_FORMAT);
        fmt.setTimeZone(UTC_TIME_ZONE);
        return fmt;
    }

    public Map<String, String> toProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("scanEndTime", String.valueOf(this.scanEndTime.getTime()));
        properties.put("scanStartTime", String.valueOf(this.scanStartTime.getTime()));
        properties.put("totalArtifactCount", String.valueOf(this.totalArtifactCount));
        properties.put("totalArtifactFileSize", String.valueOf(this.totalArtifactFileSize));
        properties.put("totalFileCount", String.valueOf(this.totalFileCount));
        properties.put("totalGroupCount", String.valueOf(this.totalGroupCount));
        properties.put("totalProjectCount", String.valueOf(this.totalProjectCount));
        properties.put("newFileCount", String.valueOf(this.newFileCount));
        properties.put("repositoryId", this.repositoryId);
        for (Map.Entry<String, Long> entry : this.totalCountForType.entrySet()) {
            properties.put("count-" + entry.getKey(), String.valueOf(entry.getValue()));
        }
        return properties;
    }

    public void fromProperties(Map<String, String> properties) {
        this.scanEndTime = new Date(Long.parseLong(properties.get("scanEndTime")));
        this.scanStartTime = new Date(Long.parseLong(properties.get("scanStartTime")));
        this.totalArtifactCount = Long.parseLong(properties.get("totalArtifactCount"));
        this.totalArtifactFileSize = Long.parseLong(properties.get("totalArtifactFileSize"));
        this.totalFileCount = Long.parseLong(properties.get("totalFileCount"));
        this.totalGroupCount = Long.parseLong(properties.get("totalGroupCount"));
        this.totalProjectCount = Long.parseLong(properties.get("totalProjectCount"));
        this.newFileCount = Long.parseLong(properties.get("newFileCount"));
        this.repositoryId = properties.get("repositoryId");
        this.totalCountForType.clear();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith("count-")) continue;
            this.totalCountForType.put(entry.getKey().substring(6), Long.valueOf(entry.getValue()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStatistics that = (RepositoryStatistics)o;
        if (this.newFileCount != that.newFileCount) {
            return false;
        }
        if (this.totalArtifactCount != that.totalArtifactCount) {
            return false;
        }
        if (this.totalArtifactFileSize != that.totalArtifactFileSize) {
            return false;
        }
        if (this.totalFileCount != that.totalFileCount) {
            return false;
        }
        if (this.totalGroupCount != that.totalGroupCount) {
            return false;
        }
        if (this.totalProjectCount != that.totalProjectCount) {
            return false;
        }
        if (!this.scanEndTime.equals(that.scanEndTime)) {
            return false;
        }
        if (!this.scanStartTime.equals(that.scanStartTime)) {
            return false;
        }
        if (!this.totalCountForType.equals(that.totalCountForType)) {
            return false;
        }
        return this.repositoryId.equals(that.repositoryId);
    }

    public int hashCode() {
        int result = this.scanEndTime.hashCode();
        result = 31 * result + this.scanStartTime.hashCode();
        result = 31 * result + (int)(this.totalArtifactCount ^ this.totalArtifactCount >>> 32);
        result = 31 * result + (int)(this.totalArtifactFileSize ^ this.totalArtifactFileSize >>> 32);
        result = 31 * result + (int)(this.totalFileCount ^ this.totalFileCount >>> 32);
        result = 31 * result + (int)(this.totalGroupCount ^ this.totalGroupCount >>> 32);
        result = 31 * result + (int)(this.totalProjectCount ^ this.totalProjectCount >>> 32);
        result = 31 * result + (int)(this.newFileCount ^ this.newFileCount >>> 32);
        result = 31 * result + this.totalCountForType.hashCode();
        result = 31 * result + this.repositoryId.hashCode();
        return result;
    }

    public String toString() {
        return "RepositoryStatistics{scanEndTime=" + this.scanEndTime + ", scanStartTime=" + this.scanStartTime + ", totalArtifactCount=" + this.totalArtifactCount + ", totalArtifactFileSize=" + this.totalArtifactFileSize + ", totalFileCount=" + this.totalFileCount + ", totalGroupCount=" + this.totalGroupCount + ", totalProjectCount=" + this.totalProjectCount + ", newFileCount=" + this.newFileCount + ", totalCountForType=" + this.totalCountForType + ", repositoryId=" + this.repositoryId + '}';
    }

    public Map<String, Long> getTotalCountForType() {
        return this.totalCountForType;
    }

    public long getTotalCountForType(String type) {
        return this.totalCountForType.get(type);
    }

    public void setTotalCountForType(String type, long count) {
        this.totalCountForType.put(type.replaceAll("-", "_").replaceAll("\\.", "_"), count);
    }

    private static final class ZeroForNullHashMap<K, V extends Long>
    extends HashMap<K, V> {
        private ZeroForNullHashMap() {
        }

        @Override
        public V get(Object key) {
            Long value = (Long)super.get(key);
            return (V)(value != null ? value : Long.valueOf(0L));
        }
    }
}

