/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.stats;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.maven2.MavenArtifactFacet;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolutionException;
import org.apache.archiva.metadata.repository.stats.RepositoryStatistics;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.commons.lang.time.StopWatch;
import org.apache.jackrabbit.commons.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="repositoryStatisticsManager#default")
public class DefaultRepositoryStatisticsManager
implements RepositoryStatisticsManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryStatisticsManager.class);
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");

    @Override
    public boolean hasStatistics(MetadataRepository metadataRepository, String repositoryId) throws MetadataRepositoryException {
        return metadataRepository.hasMetadataFacet(repositoryId, RepositoryStatistics.FACET_ID);
    }

    @Override
    public RepositoryStatistics getLastStatistics(MetadataRepository metadataRepository, String repositoryId) throws MetadataRepositoryException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List scans = metadataRepository.getMetadataFacets(repositoryId, RepositoryStatistics.FACET_ID);
        if (scans == null) {
            return null;
        }
        Collections.sort(scans);
        if (!scans.isEmpty()) {
            String name = (String)scans.get(scans.size() - 1);
            RepositoryStatistics repositoryStatistics = (RepositoryStatistics)RepositoryStatistics.class.cast(metadataRepository.getMetadataFacet(repositoryId, RepositoryStatistics.FACET_ID, name));
            stopWatch.stop();
            log.debug("time to find last RepositoryStatistics: {} ms", (Object)stopWatch.getTime());
            return repositoryStatistics;
        }
        return null;
    }

    private void walkRepository(MetadataRepository metadataRepository, RepositoryStatistics stats, String repositoryId, String ns) throws MetadataResolutionException {
        for (String namespace : metadataRepository.getNamespaces(repositoryId, ns)) {
            this.walkRepository(metadataRepository, stats, repositoryId, ns + "." + namespace);
        }
        Collection projects = metadataRepository.getProjects(repositoryId, ns);
        if (!projects.isEmpty()) {
            stats.setTotalGroupCount(stats.getTotalGroupCount() + 1L);
            stats.setTotalProjectCount(stats.getTotalProjectCount() + (long)projects.size());
            for (String project : projects) {
                for (String version : metadataRepository.getProjectVersions(repositoryId, ns, project)) {
                    for (ArtifactMetadata artifact : metadataRepository.getArtifacts(repositoryId, ns, project, version)) {
                        stats.setTotalArtifactCount(stats.getTotalArtifactCount() + 1L);
                        stats.setTotalArtifactFileSize(stats.getTotalArtifactFileSize() + artifact.getSize());
                        MavenArtifactFacet facet = (MavenArtifactFacet)artifact.getFacet("org.apache.archiva.metadata.repository.storage.maven2.artifact");
                        if (facet == null) continue;
                        String type = facet.getType();
                        stats.setTotalCountForType(type, stats.getTotalCountForType(type) + 1L);
                    }
                }
            }
        }
    }

    @Override
    public void addStatisticsAfterScan(MetadataRepository metadataRepository, String repositoryId, Date startTime, Date endTime, long totalFiles, long newFiles) throws MetadataRepositoryException {
        RepositoryStatistics repositoryStatistics = new RepositoryStatistics();
        repositoryStatistics.setRepositoryId(repositoryId);
        repositoryStatistics.setScanStartTime(startTime);
        repositoryStatistics.setScanEndTime(endTime);
        repositoryStatistics.setTotalFileCount(totalFiles);
        repositoryStatistics.setNewFileCount(newFiles);
        long startGather = System.currentTimeMillis();
        if (metadataRepository.canObtainAccess(Session.class)) {
            this.populateStatisticsFromJcr((Session)metadataRepository.obtainAccess(Session.class), repositoryId, repositoryStatistics);
        } else {
            this.populateStatisticsFromRepositoryWalk(metadataRepository, repositoryId, repositoryStatistics);
        }
        log.info("Gathering statistics executed in {} ms", (Object)(System.currentTimeMillis() - startGather));
        metadataRepository.addMetadataFacet(repositoryId, (MetadataFacet)repositoryStatistics);
    }

    private void populateStatisticsFromJcr(Session session, String repositoryId, RepositoryStatistics repositoryStatistics) throws MetadataRepositoryException {
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String whereClause = "WHERE jcr:path LIKE '/repositories/" + repositoryId + "/content/%'";
            Query query = queryManager.createQuery("SELECT size FROM archiva:artifact " + whereClause, "sql");
            QueryResult queryResult = query.execute();
            HashMap<String, Integer> totalByType = new HashMap<String, Integer>();
            long totalSize = 0L;
            long totalArtifacts = 0L;
            for (Row row : JcrUtils.getRows((QueryResult)queryResult)) {
                String type;
                Node n = row.getNode();
                totalSize += row.getValue("size").getLong();
                if (n.hasNode("org.apache.archiva.metadata.repository.storage.maven2.artifact")) {
                    Node facetNode = n.getNode("org.apache.archiva.metadata.repository.storage.maven2.artifact");
                    type = facetNode.getProperty("type").getString();
                } else {
                    type = "Other";
                }
                Integer prev = (Integer)totalByType.get(type);
                totalByType.put(type, prev != null ? prev + 1 : 1);
                ++totalArtifacts;
            }
            repositoryStatistics.setTotalArtifactCount(totalArtifacts);
            repositoryStatistics.setTotalArtifactFileSize(totalSize);
            for (Map.Entry entry : totalByType.entrySet()) {
                repositoryStatistics.setTotalCountForType((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            query = queryManager.createQuery("SELECT * FROM archiva:project " + whereClause + " ORDER BY jcr:score", "sql");
            repositoryStatistics.setTotalProjectCount(query.execute().getRows().getSize());
            query = queryManager.createQuery("SELECT * FROM archiva:namespace " + whereClause + " AND namespace IS NOT NULL ORDER BY jcr:score", "sql");
            repositoryStatistics.setTotalGroupCount(query.execute().getRows().getSize());
        }
        catch (RepositoryException e) {
            throw new MetadataRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private void populateStatisticsFromRepositoryWalk(MetadataRepository metadataRepository, String repositoryId, RepositoryStatistics repositoryStatistics) throws MetadataRepositoryException {
        try {
            for (String ns : metadataRepository.getRootNamespaces(repositoryId)) {
                this.walkRepository(metadataRepository, repositoryStatistics, repositoryId, ns);
            }
        }
        catch (MetadataResolutionException e) {
            throw new MetadataRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteStatistics(MetadataRepository metadataRepository, String repositoryId) throws MetadataRepositoryException {
        metadataRepository.removeMetadataFacets(repositoryId, RepositoryStatistics.FACET_ID);
    }

    @Override
    public List<RepositoryStatistics> getStatisticsInRange(MetadataRepository metadataRepository, String repositoryId, Date startTime, Date endTime) throws MetadataRepositoryException {
        ArrayList<RepositoryStatistics> results = new ArrayList<RepositoryStatistics>();
        List list = metadataRepository.getMetadataFacets(repositoryId, RepositoryStatistics.FACET_ID);
        Collections.sort(list, Collections.reverseOrder());
        for (String name : list) {
            try {
                Date date = DefaultRepositoryStatisticsManager.createNameFormat().parse(name);
                if (startTime != null && date.before(startTime) || endTime != null && date.after(endTime)) continue;
                RepositoryStatistics stats = (RepositoryStatistics)metadataRepository.getMetadataFacet(repositoryId, RepositoryStatistics.FACET_ID, name);
                results.add(stats);
            }
            catch (ParseException e) {
                log.error("Invalid scan result found in the metadata repository: " + e.getMessage());
            }
        }
        return results;
    }

    private static SimpleDateFormat createNameFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd/HHmmss.SSS");
        fmt.setTimeZone(UTC_TIME_ZONE);
        return fmt;
    }
}

