/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationBaseSenderController;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sender;

public final class AMQPFederationAddressSenderController
extends AMQPFederationBaseSenderController {
    public AMQPFederationAddressSenderController(AMQPSessionContext session) {
        super(session);
    }

    @Override
    public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
        AddressQueryResult addressQueryResult;
        String selector;
        Sender sender = senderContext.getSender();
        Source source = (Source)sender.getRemoteSource();
        SimpleString queueName = SimpleString.toSimpleString((String)sender.getName());
        Connection protonConnection = sender.getSession().getConnection();
        Record attachments = protonConnection.attachments();
        if (attachments.get((Object)"FEDERATION_INSTANCE_RECORD", AMQPFederation.class) == null) {
            throw new ActiveMQAMQPIllegalStateException("Cannot create a federation link from non-federation connection");
        }
        sender.setSenderSettleMode(sender.getRemoteSenderSettleMode());
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        sender.setOfferedCapabilities(new Symbol[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER});
        sender.setDesiredCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
        this.tunnelCoreMessages = AmqpSupport.verifyOfferedCapabilities((Link)sender, AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT);
        Map addressSourceProperties = sender.getRemoteProperties() == null || !sender.getRemoteProperties().containsKey(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES) ? Collections.EMPTY_MAP : (Map)sender.getRemoteProperties().get(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES);
        boolean autoDelete = addressSourceProperties.getOrDefault("auto-delete", false);
        long autoDeleteDelay = ((Number)addressSourceProperties.getOrDefault("auto-delete-delay", 0)).longValue();
        long autoDeleteMsgCount = ((Number)addressSourceProperties.getOrDefault("auto-delete-msg-count", 0)).longValue();
        Map.Entry<Symbol, DescribedType> filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS);
        if (filter != null) {
            selector = filter.getValue().getDescribed().toString();
            try {
                SelectorParser.parse((String)selector);
            }
            catch (FilterException e) {
                throw new ActiveMQAMQPException(AmqpError.INVALID_FIELD, "Invalid filter", ActiveMQExceptionType.INVALID_FILTER_EXPRESSION);
            }
        } else {
            selector = null;
        }
        SimpleString address = SimpleString.toSimpleString((String)source.getAddress());
        try {
            addressQueryResult = this.sessionSPI.addressQuery(address, RoutingType.MULTICAST, true);
        }
        catch (ActiveMQSecurityException e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e.getMessage());
        }
        catch (ActiveMQAMQPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
        }
        if (!addressQueryResult.isExists()) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
        }
        Set routingTypes = addressQueryResult.getRoutingTypes();
        if (!routingTypes.contains(RoutingType.MULTICAST)) {
            throw new ActiveMQAMQPIllegalStateException("Address " + address + " is not configured for MULTICAST support");
        }
        RoutingType routingType = AMQPFederationAddressSenderController.getRoutingType(source);
        QueueQueryResult queueQuery = this.sessionSPI.queueQuery(queueName, routingType, false);
        if (!queueQuery.isExists()) {
            QueueConfiguration configuration = new QueueConfiguration(queueName);
            configuration.setAddress(address);
            configuration.setRoutingType(routingType);
            configuration.setAutoCreateAddress(Boolean.valueOf(false));
            configuration.setMaxConsumers(Integer.valueOf(-1));
            configuration.setPurgeOnNoConsumers(Boolean.valueOf(false));
            configuration.setFilterString(selector);
            configuration.setDurable(Boolean.valueOf(true));
            configuration.setAutoCreated(Boolean.valueOf(false));
            configuration.setAutoDelete(Boolean.valueOf(autoDelete));
            configuration.setAutoDeleteDelay(Long.valueOf(autoDeleteDelay));
            configuration.setAutoDeleteMessageCount(Long.valueOf(autoDeleteMsgCount));
            queueQuery = this.sessionSPI.queueQuery(configuration, true);
        }
        if (!queueQuery.getAddress().equals((Object)address)) {
            throw new ActiveMQAMQPIllegalStateException("Requested queue: " + queueName + " for federation of address: " + address + ", but it is already mapped to a different address: " + queueQuery.getAddress());
        }
        return (Consumer)this.sessionSPI.createSender(senderContext, queueName, null, false);
    }

    private static RoutingType getRoutingType(Source source) {
        if (source != null && source.getCapabilities() != null) {
            for (Symbol capability : source.getCapabilities()) {
                if (AmqpSupport.TOPIC_CAPABILITY.equals(capability)) {
                    return RoutingType.MULTICAST;
                }
                if (!AmqpSupport.QUEUE_CAPABILITY.equals(capability)) continue;
                return RoutingType.ANYCAST;
            }
        }
        return ActiveMQDefaultConfiguration.getDefaultRoutingType();
    }
}

