/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.util.concurrent.TimeUnit;
import jdk.internal.misc.VM;

public class MicrosClock {
    private static long offset = -1L;
    private static long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final boolean AVAILABLE = MicrosClock.checkAvailable();

    private static boolean checkAvailable() {
        try {
            long now = MicrosClock.now();
            return now >= 0L;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    public static long now() {
        long epochSecond = offset;
        long nanoAdjustment = VM.getNanoTimeAdjustment(epochSecond);
        if (nanoAdjustment == -1L) {
            epochSecond = System.currentTimeMillis() / 1000L - 1024L;
            nanoAdjustment = VM.getNanoTimeAdjustment(epochSecond);
            if (nanoAdjustment == -1L) {
                throw new InternalError("Offset " + epochSecond + " is not in range");
            }
            offset = epochSecond;
        }
        long secs = Math.addExact(epochSecond, Math.floorDiv(nanoAdjustment, NANOS_PER_SECOND));
        long secsInUs = TimeUnit.SECONDS.toMicros(secs);
        long nsOffset = (int)Math.floorMod(nanoAdjustment, NANOS_PER_SECOND);
        long usOffset = TimeUnit.NANOSECONDS.toMicros(nsOffset);
        return secsInUs + usOffset;
    }
}

